; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt -S < %s -passes=inline,argpromotion | FileCheck %s --check-prefix=ARGPROMOTION

%S = type { %S* }

; Inlining should nuke the invoke (and any inlined calls) here even with
; argument promotion running along with it.
define void @zot() personality i32 (...)* @wibble {
; ARGPROMOTION-LABEL: define {{[^@]+}}@zot() personality i32 (...)* @wibble {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    unreachable
; ARGPROMOTION:       hoge.exit:
; ARGPROMOTION-NEXT:    br label [[BB1:%.*]]
; ARGPROMOTION:       bb1:
; ARGPROMOTION-NEXT:    unreachable
; ARGPROMOTION:       bb2:
; ARGPROMOTION-NEXT:    [[TEMP:%.*]] = landingpad { i8*, i32 }
; ARGPROMOTION-NEXT:    cleanup
; ARGPROMOTION-NEXT:    unreachable
;
bb:
  invoke void @hoge()
  to label %bb1 unwind label %bb2

bb1:
  unreachable

bb2:
  %temp = landingpad { i8*, i32 }
  cleanup
  unreachable
}

define internal void @hoge() {
bb:
  %temp = call fastcc i8* @spam(i1 (i8*)* @eggs)
  %temp1 = call fastcc i8* @spam(i1 (i8*)* @barney)
  unreachable
}

define internal fastcc i8* @spam(i1 (i8*)* %arg) {
bb:
  unreachable
}

define internal i1 @eggs(i8* %arg) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@eggs() {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    unreachable
;
bb:
  %temp = call zeroext i1 @barney(i8* %arg)
  unreachable
}

define internal i1 @barney(i8* %arg) {
bb:
  ret i1 undef
}

define i32 @test_inf_promote_caller(i32 %arg) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@test_inf_promote_caller
; ARGPROMOTION-SAME: (i32 [[ARG:%.*]]) {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    [[TEMP:%.*]] = alloca [[S:%.*]], align 8
; ARGPROMOTION-NEXT:    [[TEMP1:%.*]] = alloca [[S]], align 8
; ARGPROMOTION-NEXT:    [[TEMP2:%.*]] = call i32 @test_inf_promote_callee(%S* [[TEMP]], %S* [[TEMP1]])
; ARGPROMOTION-NEXT:    ret i32 0
;
bb:
  %temp = alloca %S
  %temp1 = alloca %S
  %temp2 = call i32 @test_inf_promote_callee(%S* %temp, %S* %temp1)

  ret i32 0
}

define internal i32 @test_inf_promote_callee(%S* %arg, %S* %arg1) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@test_inf_promote_callee
; ARGPROMOTION-SAME: (%S* [[ARG:%.*]], %S* [[ARG1:%.*]]) {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    [[TEMP:%.*]] = getelementptr [[S:%.*]], %S* [[ARG1]], i32 0, i32 0
; ARGPROMOTION-NEXT:    [[TEMP2:%.*]] = load %S*, %S** [[TEMP]], align 8
; ARGPROMOTION-NEXT:    [[TEMP3:%.*]] = getelementptr [[S]], %S* [[ARG]], i32 0, i32 0
; ARGPROMOTION-NEXT:    [[TEMP4:%.*]] = load %S*, %S** [[TEMP3]], align 8
; ARGPROMOTION-NEXT:    [[TEMP5:%.*]] = call i32 @test_inf_promote_callee(%S* [[TEMP4]], %S* [[TEMP2]])
; ARGPROMOTION-NEXT:    ret i32 0
;
bb:
  %temp = getelementptr %S, %S* %arg1, i32 0, i32 0
  %temp2 = load %S*, %S** %temp
  %temp3 = getelementptr %S, %S* %arg, i32 0, i32 0
  %temp4 = load %S*, %S** %temp3
  %temp5 = call i32 @test_inf_promote_callee(%S* %temp4, %S* %temp2)

  ret i32 0
}

declare i32 @wibble(...)
