; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Tests for InstCombineCompares.cpp::foldICmpUSubSatOrUAddSatWithConstant
; - usub_sat case
; https://github.com/llvm/llvm-project/issues/58342

; ==============================================================================
; Basic tests with one user and positive arguments
; ==============================================================================
define i1 @icmp_eq_basic_positive(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_eq_basic_positive
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[ARG]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 2)
  %cmp = icmp eq i8 %sub, 5
  ret i1 %cmp
}

define i1 @icmp_ne_basic_positive(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_ne_basic_positive
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i16 [[ARG]], 17
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 8)
  %cmp = icmp ne i16 %sub, 9
  ret i1 %cmp
}

define i1 @icmp_ule_basic_positive(i32 %arg) {
; CHECK-LABEL: define i1 @icmp_ule_basic_positive
; CHECK-SAME: (i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ARG]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i32 @llvm.usub.sat.i32(i32 %arg, i32 6)
  %cmp = icmp ule i32 %sub, 3
  ret i1 %cmp
}

define i1 @icmp_ult_basic_positive(i64 %arg) {
; CHECK-LABEL: define i1 @icmp_ult_basic_positive
; CHECK-SAME: (i64 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[ARG]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i64 @llvm.usub.sat.i64(i64 %arg, i64 5)
  %cmp = icmp ult i64 %sub, 2
  ret i1 %cmp
}

define i1 @icmp_uge_basic_positive(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_uge_basic_positive
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[ARG]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 4)
  %cmp = icmp uge i8 %sub, 4
  ret i1 %cmp
}

define i1 @icmp_ugt_basic_positive(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_ugt_basic_positive
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i16 [[ARG]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 1)
  %cmp = icmp ugt i16 %sub, 3
  ret i1 %cmp
}

define i1 @icmp_sle_basic_positive(i32 %arg) {
; CHECK-LABEL: define i1 @icmp_sle_basic_positive
; CHECK-SAME: (i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[ARG]], 2147483638
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP1]], -2147483639
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i32 @llvm.usub.sat.i32(i32 %arg, i32 10)
  %cmp = icmp sle i32 %sub, 8
  ret i1 %cmp
}

define i1 @icmp_slt_basic_positive(i64 %arg) {
; CHECK-LABEL: define i1 @icmp_slt_basic_positive
; CHECK-SAME: (i64 [[ARG:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 [[ARG]], 9223372036854775784
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[TMP1]], -9223372036854775803
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i64 @llvm.usub.sat.i64(i64 %arg, i64 24)
  %cmp = icmp slt i64 %sub, 5
  ret i1 %cmp
}

define i1 @icmp_sge_basic_positive(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_sge_basic_positive
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[ARG]], -5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[TMP1]], 124
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 1)
  %cmp = icmp sge i8 %sub, 4
  ret i1 %cmp
}

define i1 @icmp_sgt_basic_positive(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_sgt_basic_positive
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add i16 [[ARG]], -8
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[TMP1]], 32762
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 2)
  %cmp = icmp sgt i16 %sub, 5
  ret i1 %cmp
}

; ==============================================================================
; Basic tests with one user and negative arguments
; ==============================================================================
define i1 @icmp_eq_basic_negative(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_eq_basic_negative
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[ARG]], -15
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 -20)
  %cmp = icmp eq i8 %sub, 5
  ret i1 %cmp
}

define i1 @icmp_ne_basic_negative(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_ne_basic_negative
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i16 [[ARG]], -71
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 -80)
  %cmp = icmp ne i16 %sub, 9
  ret i1 %cmp
}

define i1 @icmp_ule_basic_negative(i32 %arg) {
; CHECK-LABEL: define i1 @icmp_ule_basic_negative
; CHECK-SAME: (i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ARG]], -2
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i32 @llvm.usub.sat.i32(i32 %arg, i32 -6)
  %cmp = icmp ule i32 %sub, 3
  ret i1 %cmp
}

define i1 @icmp_ult_basic_negative(i64 %arg) {
; CHECK-LABEL: define i1 @icmp_ult_basic_negative
; CHECK-SAME: (i64 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[ARG]], -8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i64 @llvm.usub.sat.i64(i64 %arg, i64 -10)
  %cmp = icmp ult i64 %sub, 2
  ret i1 %cmp
}

define i1 @icmp_uge_basic_negative(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_uge_basic_negative
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[ARG]], -3
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 -4)
  %cmp = icmp uge i8 %sub, 2
  ret i1 %cmp
}

define i1 @icmp_ugt_basic_negative(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_ugt_basic_negative
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i16 [[ARG]], -7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 -10)
  %cmp = icmp ugt i16 %sub, 3
  ret i1 %cmp
}

define i1 @icmp_sle_basic_negative(i32 %arg) {
; CHECK-LABEL: define i1 @icmp_sle_basic_negative
; CHECK-SAME: (i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[ARG]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i32 @llvm.usub.sat.i32(i32 %arg, i32 -10)
  %cmp = icmp sle i32 %sub, 8
  ret i1 %cmp
}

define i1 @icmp_slt_basic_negative(i64 %arg) {
; CHECK-LABEL: define i1 @icmp_slt_basic_negative
; CHECK-SAME: (i64 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[ARG]], -19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i64 @llvm.usub.sat.i64(i64 %arg, i64 -24)
  %cmp = icmp slt i64 %sub, 5
  ret i1 %cmp
}

define i1 @icmp_sge_basic_negative(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_sge_basic_negative
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[ARG]], -7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 -10)
  %cmp = icmp sge i8 %sub, 4
  ret i1 %cmp
}

define i1 @icmp_sgt_basic_negative(i16 %arg) {
; CHECK-LABEL: define i1 @icmp_sgt_basic_negative
; CHECK-SAME: (i16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i16 [[ARG]], -15
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i16 @llvm.usub.sat.i16(i16 %arg, i16 -20)
  %cmp = icmp sgt i16 %sub, 5
  ret i1 %cmp
}

; ==============================================================================
; Tests with more than user and positive arguments
; ==============================================================================
define i1 @icmp_eq_multiuse_positive(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_eq_multiuse_positive
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[ARG]], i8 2)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[SUB]], 5
; CHECK-NEXT:    call void @use.i8(i8 [[SUB]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 2)
  %cmp = icmp eq i8 %sub, 5
  call void @use.i8(i8 %sub)
  ret i1 %cmp
}

; ==============================================================================
; Tests with more than one user and negative arguments
; ==============================================================================
define i1 @icmp_eq_multiuse_negative(i8 %arg) {
; CHECK-LABEL: define i1 @icmp_eq_multiuse_negative
; CHECK-SAME: (i8 [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[ARG]], i8 -2)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[ARG]], -1
; CHECK-NEXT:    call void @use.i8(i8 [[SUB]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = call i8 @llvm.usub.sat.i8(i8 %arg, i8 -2)
  %cmp = icmp eq i8 %sub, 1
  call void @use.i8(i8 %sub)
  ret i1 %cmp
}

; ==============================================================================
; Tests with vector types and positive arguments
; ==============================================================================
define <2 x i1> @icmp_eq_vector_positive_equal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_positive_equal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[ARG]], <i8 7, i8 7>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 2, i8 2>)
  %cmp = icmp eq <2 x i8> %sub, <i8 5, i8 5>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_vector_positive_unequal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_positive_unequal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> [[ARG]], <2 x i8> <i8 1, i8 2>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[SUB]], <i8 5, i8 6>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 1, i8 2>)
  %cmp = icmp eq <2 x i8> %sub, <i8 5, i8 6>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_vector_positive_equal(<2 x i16> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_ne_vector_positive_equal
; CHECK-SAME: (<2 x i16> [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i16> [[ARG]], <i16 37, i16 37>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i16> @llvm.usub.sat.v2i16(<2 x i16> %arg, <2 x i16> <i16 32, i16 32>)
  %cmp = icmp ne <2 x i16> %sub, <i16 5, i16 5>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_vector_positive_unequal(<2 x i16> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_ne_vector_positive_unequal
; CHECK-SAME: (<2 x i16> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i16> @llvm.usub.sat.v2i16(<2 x i16> [[ARG]], <2 x i16> <i16 3, i16 33>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i16> [[SUB]], <i16 7, i16 6>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i16> @llvm.usub.sat.v2i16(<2 x i16> %arg, <2 x i16> <i16 3, i16 33>)
  %cmp = icmp ne <2 x i16> %sub, <i16 7, i16 6>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ule_vector_positive_equal(<2 x i32> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_ule_vector_positive_equal
; CHECK-SAME: (<2 x i32> [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i32> [[ARG]], <i32 37, i32 37>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i32> @llvm.usub.sat.v2i32(<2 x i32> %arg, <2 x i32> <i32 32, i32 32>)
  %cmp = icmp ult <2 x i32> %sub, <i32 5, i32 5>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ule_vector_positive_unequal(<2 x i32> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_ule_vector_positive_unequal
; CHECK-SAME: (<2 x i32> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i32> @llvm.usub.sat.v2i32(<2 x i32> [[ARG]], <2 x i32> <i32 3, i32 35>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i32> [[SUB]], <i32 5, i32 7>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i32> @llvm.usub.sat.v2i32(<2 x i32> %arg, <2 x i32> <i32 3, i32 35>)
  %cmp = icmp ult <2 x i32> %sub, <i32 5, i32 7>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_sgt_vector_positive_equal(<2 x i64> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_sgt_vector_positive_equal
; CHECK-SAME: (<2 x i64> [[ARG:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add <2 x i64> [[ARG]], <i64 -410858, i64 -410858>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i64> [[TMP1]], <i64 9223372036854774573, i64 9223372036854774573>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> %arg, <2 x i64> <i64 409623, i64 409623>)
  %cmp = icmp sgt <2 x i64> %sub, <i64 1234, i64 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_sgt_vector_positive_unequal(<2 x i64> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_sgt_vector_positive_unequal
; CHECK-SAME: (<2 x i64> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> [[ARG]], <2 x i64> <i64 320498, i64 409623>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <2 x i64> [[SUB]], <i64 1234, i64 3456>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> %arg, <2 x i64> <i64 320498, i64 409623>)
  %cmp = icmp sgt <2 x i64> %sub, <i64 1234, i64 3456>
  ret <2 x i1> %cmp
}

; ==============================================================================
; Tests with vector types and negative arguments
; ==============================================================================
define <2 x i1> @icmp_eq_vector_negative_equal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_negative_equal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[ARG]], <i8 -3, i8 -3>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 -5, i8 -5>)
  %cmp = icmp eq <2 x i8> %sub, <i8 2, i8 2>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_vector_negative_unequal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_negative_unequal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> [[ARG]], <2 x i8> <i8 -10, i8 -20>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[SUB]], <i8 5, i8 6>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 -10, i8 -20>)
  %cmp = icmp eq <2 x i8> %sub, <i8 5, i8 6>
  ret <2 x i1> %cmp
}

; ==============================================================================
; Tests with vector types, multiple uses and positive arguments
; ==============================================================================
define <2 x i1> @icmp_eq_vector_multiuse_positive_equal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_multiuse_positive_equal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> [[ARG]], <2 x i8> <i8 2, i8 2>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[SUB]], <i8 5, i8 5>
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[SUB]])
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 2, i8 2>)
  %cmp = icmp eq <2 x i8> %sub, <i8 5, i8 5>
  call void @use.v2i8(<2 x i8> %sub)
  ret <2 x i1> %cmp
}

; ==============================================================================
; Tests with vector types, multiple uses and negative arguments
; ==============================================================================
define <2 x i1> @icmp_eq_vector_multiuse_negative_equal(<2 x i8> %arg) {
; CHECK-LABEL: define <2 x i1> @icmp_eq_vector_multiuse_negative_equal
; CHECK-SAME: (<2 x i8> [[ARG:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> [[ARG]], <2 x i8> <i8 -20, i8 -20>)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[SUB]], <i8 5, i8 5>
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[SUB]])
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %arg, <2 x i8> <i8 -20, i8 -20>)
  %cmp = icmp eq <2 x i8> %sub, <i8 5, i8 5>
  call void @use.v2i8(<2 x i8> %sub)
  ret <2 x i1> %cmp
}

declare i8 @llvm.usub.sat.i8(i8, i8)
declare i16 @llvm.usub.sat.i16(i16, i16)
declare i32 @llvm.usub.sat.i32(i32, i32)
declare i64 @llvm.usub.sat.i64(i64, i64)

declare <2 x i64> @llvm.usub.sat.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i32> @llvm.usub.sat.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i16> @llvm.usub.sat.v2i16(<2 x i16>, <2 x i16>)
declare <2 x i8> @llvm.usub.sat.v2i8(<2 x i8>, <2 x i8>)

declare void @use.i8(i8)
declare void @use.v2i8(<2 x i8>)
