/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.LdapNameParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapName
implements Name {
    private static final long serialVersionUID = -1595520034788997356L;
    private transient List<Rdn> rdns;
    private transient String rdnsStr;

    public LdapName(List<Rdn> rdns) {
        if (rdns == null) {
            throw new NullPointerException("rdns " + Messages.getString("ldap.00"));
        }
        this.rdns = new ArrayList<Rdn>(rdns);
    }

    public LdapName(String name) throws InvalidNameException {
        this.rdnsStr = name;
        LdapNameParser parser = new LdapNameParser(this.rdnsStr);
        this.rdns = parser.getList();
    }

    public Name add(int posn, Rdn comp) {
        if (comp == null) {
            throw new NullPointerException("comp " + Messages.getString("ldap.00"));
        }
        if (posn < 0 || posn > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.05"));
        }
        this.rdns.add(posn, comp);
        this.rdnsStr = null;
        return this;
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        return this.add(posn, new Rdn(comp));
    }

    public Name add(Rdn comp) {
        return this.add(this.rdns.size(), comp);
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        return this.add(this.rdns.size(), comp);
    }

    public Name addAll(int posn, List<Rdn> suffixRdns) {
        if (suffixRdns == null) {
            throw new NullPointerException("suffixRdns " + Messages.getString("ldap.00"));
        }
        if (posn < 0 || posn > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.00"));
        }
        this.rdns.addAll(posn, suffixRdns);
        this.rdnsStr = null;
        return this;
    }

    @Override
    public Name addAll(int posn, Name suffix) throws InvalidNameException {
        if (suffix instanceof LdapName) {
            return this.addAll(posn, ((LdapName)suffix).rdns);
        }
        ArrayList<Rdn> rdns = new ArrayList<Rdn>();
        Enumeration<String> iter = suffix.getAll();
        while (iter.hasMoreElements()) {
            rdns.add(new Rdn(iter.nextElement()));
        }
        return this.addAll(posn, rdns);
    }

    public Name addAll(List<Rdn> suffixRdns) {
        return this.addAll(this.rdns.size(), suffixRdns);
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        return this.addAll(this.rdns.size(), suffix);
    }

    @Override
    public Object clone() {
        try {
            if (this.rdnsStr != null) {
                return new LdapName(this.rdnsStr);
            }
        }
        catch (InvalidNameException invalidNameException) {}
        ArrayList<Rdn> lista = new ArrayList<Rdn>();
        int i = 0;
        while (i < this.rdns.size()) {
            lista.add(this.rdns.get(i));
            ++i;
        }
        return new LdapName(lista);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof LdapName)) {
            throw new ClassCastException("obj " + Messages.getString("ldap.01"));
        }
        LdapName ln = (LdapName)obj;
        Iterator<Rdn> iter = this.rdns.iterator();
        Iterator<Rdn> iter2 = ln.rdns.iterator();
        while (iter.hasNext() && iter2.hasNext()) {
            int c = ((Object)iter.next()).toString().toLowerCase().compareTo(((Object)iter2.next()).toString().toLowerCase());
            if (c == 0) continue;
            return c;
        }
        if (iter.hasNext()) {
            return 1;
        }
        if (iter2.hasNext()) {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean endsWith(List<Rdn> rdns) {
        try {
            Iterator<Rdn> iter = rdns.iterator();
            Iterator<Rdn> iter2 = ((LdapName)this.getSuffix((int)(this.rdns.size() - rdns.size()))).rdns.iterator();
            do {
                if (iter.hasNext()) continue;
                return true;
            } while (iter.next().equals(iter2.next()));
            return false;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public boolean endsWith(Name n) {
        try {
            return n.equals(this.getSuffix(this.rdns.size() - n.size()));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LdapName)) {
            return false;
        }
        LdapName ln = (LdapName)obj;
        if (ln.rdns.size() != this.rdns.size()) {
            return false;
        }
        Iterator<Rdn> iter = ln.rdns.iterator();
        Iterator<Rdn> iter2 = this.rdns.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String get(int posn) {
        return this.getRdn(posn).toString();
    }

    @Override
    public Enumeration<String> getAll() {
        final Iterator<Rdn> rdns = this.getRdns().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return rdns.hasNext();
            }

            @Override
            public String nextElement() {
                return ((Rdn)rdns.next()).toString();
            }
        };
    }

    @Override
    public Name getPrefix(int posn) {
        if (posn < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.02"));
        }
        return new LdapName(this.rdns.subList(0, posn));
    }

    public Rdn getRdn(int posn) {
        return this.rdns.get(posn);
    }

    public List<Rdn> getRdns() {
        return this.rdns;
    }

    @Override
    public Name getSuffix(int posn) {
        if (posn > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.02"));
        }
        return new LdapName(this.rdns.subList(posn, this.rdns.size()));
    }

    public int hashCode() {
        int sum = 0;
        Iterator<Rdn> iter = this.rdns.iterator();
        while (iter.hasNext()) {
            sum += ((Object)iter.next()).hashCode();
        }
        return sum;
    }

    @Override
    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        this.rdnsStr = null;
        return this.rdns.remove(posn).toString();
    }

    @Override
    public int size() {
        return this.rdns.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startsWith(List<Rdn> rdns) {
        try {
            Iterator<Rdn> iter = rdns.iterator();
            Iterator<Rdn> iter2 = ((LdapName)this.getPrefix((int)rdns.size())).rdns.iterator();
            do {
                if (iter.hasNext()) continue;
                return true;
            } while (iter.next().equals(iter2.next()));
            return false;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public boolean startsWith(Name n) {
        try {
            return n.equals(this.getPrefix(n.size()));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public String toString() {
        if (this.rdnsStr != null) {
            return this.rdnsStr;
        }
        if (this.rdns.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.rdns.get(this.rdns.size() - 1).toString());
        int i = this.rdns.size() - 2;
        while (i >= 0) {
            sb.append(',');
            sb.append(this.rdns.get(i).toString());
            --i;
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, InvalidNameException {
        ois.defaultReadObject();
        LdapNameParser parser = new LdapNameParser((String)ois.readObject());
        this.rdns = parser.getList();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.toString());
    }
}

