/* utilities.c generated by valac 0.16.1, the Vala compiler
 * generated from utilities.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <unistd.h>
#include <errno.h>
#include <execinfo.h>
#include <config.h>
#include <gio/gio.h>

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define FSO_FRAMEWORK_TYPE_LOGGER (fso_framework_logger_get_type ())
#define FSO_FRAMEWORK_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLogger))
#define FSO_FRAMEWORK_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_LOGGER))
#define FSO_FRAMEWORK_LOGGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLoggerIface))

typedef struct _FsoFrameworkLogger FsoFrameworkLogger;
typedef struct _FsoFrameworkLoggerIface FsoFrameworkLoggerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _t_destroy_func0(var) (((var == NULL) || (t_destroy_func == NULL)) ? NULL : (var = (t_destroy_func (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _fso_framework_network_textForUriData fso_framework_network_textForUriData;

typedef gchar* (*ReprDelegate) (void* user_data);
struct _FsoFrameworkLoggerIface {
	GTypeInterface parent_iface;
	void (*setLevel) (FsoFrameworkLogger* self, GLogLevelFlags level);
	void (*setDestination) (FsoFrameworkLogger* self, const gchar* destination);
	void (*setReprDelegate) (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target);
	GLogLevelFlags (*getLevel) (FsoFrameworkLogger* self);
	gchar* (*getDestination) (FsoFrameworkLogger* self);
	gboolean (*debug) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*info) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*warning) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*error) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*critical) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*data) (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
};

struct _fso_framework_network_textForUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* servername;
	gchar* uri;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	GResolver* _tmp1_;
	GResolver* resolver;
	GList* addresses;
	GResolver* _tmp2_;
	const gchar* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GError* e;
	FsoFrameworkLogger* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	GInetAddress* _tmp15_;
	GInetAddress* serveraddr;
	FsoFrameworkLogger* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GInetAddress* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	GInetAddress* _tmp25_;
	GInetSocketAddress* _tmp26_;
	GInetSocketAddress* socket;
	GSocketClient* _tmp27_;
	GSocketClient* client;
	GSocketClient* _tmp28_;
	GInetSocketAddress* _tmp29_;
	GSocketConnection* _tmp30_;
	GSocketConnection* conn;
	FsoFrameworkLogger* _tmp31_;
	GInetAddress* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* message;
	GSocketConnection* _tmp43_;
	GOutputStream* _tmp44_;
	GOutputStream* _tmp45_;
	const gchar* _tmp46_;
	guint8* _tmp47_;
	gint _tmp47__length1;
	guint8* _tmp48_;
	gint _tmp48__length1;
	FsoFrameworkLogger* _tmp49_;
	gboolean _tmp50_;
	GSocketConnection* _tmp51_;
	GSocket* _tmp52_;
	GSocket* _tmp53_;
	GSocketConnection* _tmp54_;
	GInputStream* _tmp55_;
	GInputStream* _tmp56_;
	GDataInputStream* _tmp57_;
	GDataInputStream* input;
	GDataInputStream* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* line;
	FsoFrameworkLogger* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_;
	const gchar* _tmp70_;
	gboolean _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	gboolean _tmp73_;
	gboolean _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	gboolean _tmp77_;
	const gchar* _tmp78_;
	gboolean _tmp79_;
	GDataInputStream* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	const gchar* _tmp83_;
	FsoFrameworkLogger* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gboolean _tmp91_;
	const gchar* _tmp92_;
	GDataInputStream* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	gboolean _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gboolean _tmp101_;
	const gchar* _tmp102_;
	gboolean _tmp103_;
	const gchar* _tmp104_;
	gboolean _tmp105_;
	FsoFrameworkLogger* _tmp106_;
	const gchar* _tmp107_;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gboolean _tmp111_;
	gchar** _tmp112_;
	gint _tmp112__length1;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	gchar** _tmp115_;
	gint _tmp115__length1;
	GError * _inner_error_;
};


extern gchar* _hardware;
gchar* _hardware = NULL;
extern gchar* _prefix;
gchar* _prefix = NULL;
extern gchar* _program;
gchar* _program = NULL;
extern GHashTable* _hashtable;
GHashTable* _hashtable = NULL;
extern FsoFrameworkLogger* fso_framework_theLogger;

#define PROC_SELF_CMDLINE "/proc/self/cmdline"
#define PROC_SELF_EXE "/proc/self/exe"
#define PROC_CPUINFO "/proc/cpuinfo"
#define BACKTRACE_SIZE 50
void fso_framework_data_sharing_setValueForKey (const gchar* key, void* val);
static void _g_free0_ (gpointer var);
void* fso_framework_data_sharing_valueForKey (const gchar* key);
uid_t fso_framework_user_group_handling_uidForUser (const gchar* user);
gid_t fso_framework_user_group_handling_gidForGroup (const gchar* group);
gboolean fso_framework_user_group_handling_switchToUserAndGroup (const gchar* user, const gchar* group);
GType fso_framework_logger_get_type (void) G_GNUC_CONST;
gboolean fso_framework_logger_warning (FsoFrameworkLogger* self, const gchar* message);
#define FSO_FRAMEWORK_UTILITY_BUF_SIZE ((guint) 1024)
gchar* fso_framework_utility_programName (void);
gchar* fso_framework_utility_prefixForExecutable (void);
gchar* fso_framework_file_handling_read (const gchar* filename);
gchar** fso_framework_utility_createBacktrace (int* result_length1);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
gchar* fso_framework_utility_firstAvailableProgram (gchar** candidates, int candidates_length1);
gchar* fso_framework_utility_hardware (void);
gchar* fso_framework_utility_machineConfigurationDir (void);
gchar* fso_framework_utility_dataToString (guint8* data, int data_length1, gint limit);
gint fso_framework_utility_copyData (guint8** destination, int* destination_length1, guint8* source, int source_length1, gint limit);
gpointer* fso_framework_utility_listToArray (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GList* list, int* result_length1);
static void fso_framework_network_textForUri_data_free (gpointer _data);
void fso_framework_network_textForUri (const gchar* servername, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** fso_framework_network_textForUri_finish (GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean fso_framework_network_textForUri_co (fso_framework_network_textForUriData* _data_);
static void fso_framework_network_textForUri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean fso_framework_logger_debug (FsoFrameworkLogger* self, const gchar* message);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void fso_framework_data_sharing_setValueForKey (const gchar* key, void* val) {
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	void* _tmp7_;
	g_return_if_fail (key != NULL);
	_tmp0_ = _hashtable;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, NULL);
		_g_hash_table_unref0 (_hashtable);
		_hashtable = _tmp3_;
	}
	_tmp4_ = _hashtable;
	_tmp5_ = key;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = val;
	g_hash_table_insert (_tmp4_, _tmp6_, _tmp7_);
}


void* fso_framework_data_sharing_valueForKey (const gchar* key) {
	void* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _hashtable;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, NULL);
		_g_hash_table_unref0 (_hashtable);
		_hashtable = _tmp3_;
	}
	_tmp4_ = _hashtable;
	_tmp5_ = key;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


uid_t fso_framework_user_group_handling_uidForUser (const gchar* user) {
	uid_t result = {0};
	struct passwd* _tmp0_ = NULL;
	struct passwd* pw;
	g_return_val_if_fail (user != NULL, result);
	setpwent ();
	_tmp0_ = getpwent ();
	pw = _tmp0_;
	while (TRUE) {
		struct passwd* _tmp1_;
		struct passwd* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		struct passwd* _tmp7_ = NULL;
		_tmp1_ = pw;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = pw;
		_tmp3_ = _tmp2_->pw_name;
		_tmp4_ = user;
		if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
			struct passwd* _tmp5_;
			uid_t _tmp6_;
			_tmp5_ = pw;
			_tmp6_ = _tmp5_->pw_uid;
			result = _tmp6_;
			return result;
		}
		_tmp7_ = getpwent ();
		pw = _tmp7_;
	}
	result = (uid_t) (-1);
	return result;
}


gid_t fso_framework_user_group_handling_gidForGroup (const gchar* group) {
	gid_t result = {0};
	struct group* _tmp0_ = NULL;
	struct group* gr;
	g_return_val_if_fail (group != NULL, result);
	setgrent ();
	_tmp0_ = getgrent ();
	gr = _tmp0_;
	while (TRUE) {
		struct group* _tmp1_;
		struct group* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		struct group* _tmp7_ = NULL;
		_tmp1_ = gr;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = gr;
		_tmp3_ = _tmp2_->gr_name;
		_tmp4_ = group;
		if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
			struct group* _tmp5_;
			gid_t _tmp6_;
			_tmp5_ = gr;
			_tmp6_ = _tmp5_->gr_gid;
			result = _tmp6_;
			return result;
		}
		_tmp7_ = getgrent ();
		gr = _tmp7_;
	}
	result = (gid_t) (-1);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gboolean fso_framework_user_group_handling_switchToUserAndGroup (const gchar* user, const gchar* group) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	uid_t _tmp1_ = {0};
	uid_t uid;
	const gchar* _tmp2_;
	gid_t _tmp3_ = {0};
	gid_t gid;
	gboolean _tmp4_ = FALSE;
	uid_t _tmp5_;
	gboolean _tmp7_;
	gid_t _tmp8_;
	gint _tmp9_ = 0;
	gint ok;
	gint _tmp10_;
	uid_t _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_;
	g_return_val_if_fail (user != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp0_ = user;
	_tmp1_ = fso_framework_user_group_handling_uidForUser (_tmp0_);
	uid = _tmp1_;
	_tmp2_ = group;
	_tmp3_ = fso_framework_user_group_handling_gidForGroup (_tmp2_);
	gid = _tmp3_;
	_tmp5_ = uid;
	if (_tmp5_ == ((uid_t) (-1))) {
		_tmp4_ = TRUE;
	} else {
		gid_t _tmp6_;
		_tmp6_ = gid;
		_tmp4_ = _tmp6_ == ((gid_t) (-1));
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = gid;
	_tmp9_ = setgid (_tmp8_);
	ok = _tmp9_;
	_tmp10_ = ok;
	if (_tmp10_ != 0) {
		FsoFrameworkLogger* _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp11_ = fso_framework_theLogger;
		_tmp12_ = errno;
		_tmp13_ = strerror (_tmp12_);
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("Can't set group id: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		fso_framework_logger_warning (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
		result = FALSE;
		return result;
	}
	_tmp17_ = uid;
	_tmp18_ = setuid (_tmp17_);
	ok = _tmp18_;
	_tmp19_ = ok;
	if (_tmp19_ != 0) {
		FsoFrameworkLogger* _tmp20_;
		gint _tmp21_;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp20_ = fso_framework_theLogger;
		_tmp21_ = errno;
		_tmp22_ = strerror (_tmp21_);
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("Can't set user id: ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		fso_framework_logger_warning (_tmp20_, _tmp25_);
		_g_free0 (_tmp25_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gchar* fso_framework_utility_programName (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	_tmp0_ = _program;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_get_prgname ();
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_program);
		_program = _tmp2_;
		_tmp3_ = _program;
		if (_tmp3_ == NULL) {
			gchar* _tmp4_ = NULL;
			gchar* buf;
			gint buf_length1;
			gint _buf_size_;
			gchar* _tmp5_;
			gint _tmp5__length1;
			gssize _tmp6_ = 0L;
			gssize length;
			gchar* _tmp7_;
			gint _tmp7__length1;
			gssize _tmp8_;
			gchar _tmp9_;
			gssize _tmp10_;
			gchar* _tmp11_;
			gint _tmp11__length1;
			gchar* _tmp12_ = NULL;
			_tmp4_ = g_new0 (gchar, FSO_FRAMEWORK_UTILITY_BUF_SIZE);
			buf = _tmp4_;
			buf_length1 = FSO_FRAMEWORK_UTILITY_BUF_SIZE;
			_buf_size_ = buf_length1;
			_tmp5_ = buf;
			_tmp5__length1 = buf_length1;
			_tmp6_ = readlink (PROC_SELF_EXE, _tmp5_, _tmp5__length1);
			length = _tmp6_;
			_tmp7_ = buf;
			_tmp7__length1 = buf_length1;
			_tmp8_ = length;
			_tmp7_[_tmp8_] = (gchar) 0;
			_tmp9_ = _tmp7_[_tmp8_];
			_tmp10_ = length;
			g_assert (_tmp10_ != ((gssize) 0));
			_tmp11_ = buf;
			_tmp11__length1 = buf_length1;
			_tmp12_ = g_path_get_basename ((const gchar*) _tmp11_);
			_g_free0 (_program);
			_program = _tmp12_;
			buf = (g_free (buf), NULL);
		}
	}
	_tmp13_ = _program;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	return result;
}


gchar* fso_framework_utility_prefixForExecutable (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	_tmp0_ = _prefix;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		gchar* cmd;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* pte;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_ = NULL;
		_tmp1_ = fso_framework_file_handling_read (PROC_SELF_CMDLINE);
		cmd = _tmp1_;
		_tmp2_ = cmd;
		_tmp3_ = g_find_program_in_path (_tmp2_);
		pte = _tmp3_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_prefix);
		_prefix = _tmp4_;
		_tmp5_ = pte;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 0);
		{
			gchar** component_collection = NULL;
			gint component_collection_length1 = 0;
			gint _component_collection_size_ = 0;
			gint component_it = 0;
			component_collection = _tmp7_;
			component_collection_length1 = _vala_array_length (_tmp6_);
			for (component_it = 0; component_it < _vala_array_length (_tmp6_); component_it = component_it + 1) {
				gchar* _tmp8_;
				gchar* component = NULL;
				_tmp8_ = g_strdup (component_collection[component_it]);
				component = _tmp8_;
				{
					const gchar* _tmp9_;
					gboolean _tmp10_ = FALSE;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp9_ = component;
					_tmp10_ = g_str_has_suffix (_tmp9_, "bin");
					if (_tmp10_) {
						_g_free0 (component);
						break;
					}
					_tmp11_ = _prefix;
					_tmp12_ = component;
					_tmp13_ = g_strdup_printf ("%s%c", _tmp12_, (gint) G_DIR_SEPARATOR);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
					_g_free0 (_prefix);
					_prefix = _tmp15_;
					_g_free0 (_tmp14_);
					_g_free0 (component);
				}
			}
			component_collection = (_vala_array_free (component_collection, component_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (pte);
		_g_free0 (cmd);
	}
	_tmp16_ = _prefix;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	return result;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** fso_framework_utility_createBacktrace (int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	void* _tmp1_ = NULL;
	void* buffer;
	void* _tmp2_;
	gint _tmp3_ = 0;
	gint size;
	void* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** symbols;
	gint symbols_length1;
	gint _symbols_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = g_malloc0 ((gsize) (BACKTRACE_SIZE * sizeof (gchar*)));
	buffer = _tmp1_;
	_tmp2_ = buffer;
	_tmp3_ = backtrace (_tmp2_, BACKTRACE_SIZE);
	size = _tmp3_;
	_tmp4_ = buffer;
	_tmp5_ = size;
	_tmp6_ = backtrace_symbols (_tmp4_, _tmp5_);
	symbols = _tmp6_;
	symbols_length1 = -1;
	_symbols_size_ = symbols_length1;
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	_tmp8_ = size;
	_tmp9_ = g_strdup_printf ("--- BACKTRACE (%zd frames) ---\n", (gssize) _tmp8_);
	_vala_array_add7 (&_result_, &_result__length1, &__result__size_, _tmp9_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = size;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = _result_;
				_tmp15__length1 = _result__length1;
				_tmp16_ = symbols;
				_tmp16__length1 = symbols_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp19_ = g_strdup_printf ("%s\n", _tmp18_);
				_vala_array_add8 (&_result_, &_result__length1, &__result__size_, _tmp19_);
			}
		}
	}
	_tmp20_ = _result_;
	_tmp20__length1 = _result__length1;
	_tmp21_ = g_strdup ("--- END BACKTRACE ---\n");
	_vala_array_add9 (&_result_, &_result__length1, &__result__size_, _tmp21_);
	_tmp22_ = _result_;
	_tmp22__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	symbols = (_vala_array_free (symbols, symbols_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* fso_framework_utility_firstAvailableProgram (gchar** candidates, int candidates_length1) {
	gchar* result = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* pte;
				const gchar* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = candidates;
				_tmp4__length1 = candidates_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = candidates;
				_tmp5__length1 = candidates_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = g_find_program_in_path (_tmp7_);
				pte = _tmp8_;
				_tmp9_ = pte;
				if (_tmp9_ != NULL) {
					result = pte;
					return result;
				}
				_g_free0 (pte);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch17_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch17_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally17;
	__catch17_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* fso_framework_utility_hardware (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* proc_cpuinfo;
	const gchar* _tmp5_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	_tmp0_ = _hardware;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = _hardware;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup ("default");
	_g_free0 (_hardware);
	_hardware = _tmp3_;
	_tmp4_ = fso_framework_file_handling_read (PROC_CPUINFO);
	proc_cpuinfo = _tmp4_;
	_tmp5_ = proc_cpuinfo;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_ = NULL;
		_tmp6_ = proc_cpuinfo;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp8_;
			line_collection_length1 = _vala_array_length (_tmp7_);
			for (line_it = 0; line_it < _vala_array_length (_tmp7_); line_it = line_it + 1) {
				gchar* _tmp9_;
				gchar* line = NULL;
				_tmp9_ = g_strdup (line_collection[line_it]);
				line = _tmp9_;
				{
					const gchar* _tmp10_;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp10_ = line;
					_tmp11_ = g_str_has_prefix (_tmp10_, "Hardware");
					if (_tmp11_) {
						const gchar* _tmp12_;
						gchar** _tmp13_;
						gchar** _tmp14_ = NULL;
						gchar** parts;
						gint parts_length1;
						gint _parts_size_;
						gchar* _tmp15_ = NULL;
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp12_ = line;
						_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, ": ", 0);
						parts = _tmp14_;
						parts_length1 = _vala_array_length (_tmp13_);
						_parts_size_ = parts_length1;
						_tmp16_ = parts;
						_tmp16__length1 = parts_length1;
						if (_tmp16__length1 == 2) {
							gchar** _tmp17_;
							gint _tmp17__length1;
							const gchar* _tmp18_;
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_ = NULL;
							_tmp17_ = parts;
							_tmp17__length1 = parts_length1;
							_tmp18_ = _tmp17_[1];
							_tmp19_ = string_strip (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = string_replace (_tmp20_, " ", "");
							_g_free0 (_tmp15_);
							_tmp15_ = _tmp21_;
							_g_free0 (_tmp20_);
						} else {
							gchar* _tmp22_;
							_tmp22_ = g_strdup ("unknown");
							_g_free0 (_tmp15_);
							_tmp15_ = _tmp22_;
						}
						_tmp23_ = _tmp15_;
						_tmp24_ = g_strdup (_tmp23_);
						_g_free0 (_hardware);
						_hardware = _tmp24_;
						_g_free0 (_tmp15_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						break;
					}
					_tmp25_ = line;
					_tmp26_ = g_str_has_prefix (_tmp25_, "vendor_id");
					if (_tmp26_) {
						const gchar* _tmp27_;
						gchar** _tmp28_;
						gchar** _tmp29_ = NULL;
						gchar** parts;
						gint parts_length1;
						gint _parts_size_;
						gchar* _tmp30_ = NULL;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp27_ = line;
						_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ": ", 0);
						parts = _tmp29_;
						parts_length1 = _vala_array_length (_tmp28_);
						_parts_size_ = parts_length1;
						_tmp31_ = parts;
						_tmp31__length1 = parts_length1;
						if (_tmp31__length1 == 2) {
							gchar** _tmp32_;
							gint _tmp32__length1;
							const gchar* _tmp33_;
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_;
							gchar* _tmp36_ = NULL;
							_tmp32_ = parts;
							_tmp32__length1 = parts_length1;
							_tmp33_ = _tmp32_[1];
							_tmp34_ = string_strip (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = string_replace (_tmp35_, " ", "");
							_g_free0 (_tmp30_);
							_tmp30_ = _tmp36_;
							_g_free0 (_tmp35_);
						} else {
							gchar* _tmp37_;
							_tmp37_ = g_strdup ("unknown");
							_g_free0 (_tmp30_);
							_tmp30_ = _tmp37_;
						}
						_tmp38_ = _tmp30_;
						_tmp39_ = g_strdup (_tmp38_);
						_g_free0 (_hardware);
						_hardware = _tmp39_;
						_g_free0 (_tmp30_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						break;
					}
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp40_ = _hardware;
	_tmp41_ = g_strdup (_tmp40_);
	result = _tmp41_;
	_g_free0 (proc_cpuinfo);
	return result;
}


gchar* fso_framework_utility_machineConfigurationDir (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	_tmp0_ = fso_framework_utility_hardware ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (SYSCONFDIR, "freesmartphone", "conf", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gchar* fso_framework_utility_dataToString (guint8* data, int data_length1, gint limit) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	const gchar* str;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	_tmp1_ = limit;
	if (_tmp1_ == (-1)) {
		_tmp0_ = TRUE;
	} else {
		guint8* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		_tmp2_ = data;
		_tmp2__length1 = data_length1;
		_tmp3_ = limit;
		_tmp0_ = _tmp2__length1 < _tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = data;
		_tmp5__length1 = data_length1;
		limit = _tmp5__length1;
	}
	_tmp6_ = data;
	_tmp6__length1 = data_length1;
	str = (const gchar*) _tmp6_;
	_tmp7_ = limit;
	_tmp8_ = g_strndup (str, (gsize) _tmp7_);
	result = _tmp8_;
	return result;
}


gint fso_framework_utility_copyData (guint8** destination, int* destination_length1, guint8* source, int source_length1, gint limit) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint length;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp5_;
	gint _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	_tmp0_ = *destination;
	_tmp0__length1 = *destination_length1;
	length = _tmp0__length1;
	_tmp2_ = limit;
	if (_tmp2_ >= 0) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = limit;
		_tmp4_ = length;
		_tmp1_ = _tmp3_ < _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		gint _tmp6_;
		_tmp6_ = limit;
		length = _tmp6_;
	}
	_tmp7_ = length;
	_tmp8_ = source;
	_tmp8__length1 = source_length1;
	if (_tmp7_ > _tmp8__length1) {
		guint8* _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = source;
		_tmp9__length1 = source_length1;
		length = _tmp9__length1;
	}
	_tmp10_ = *destination;
	_tmp10__length1 = *destination_length1;
	_tmp11_ = source;
	_tmp11__length1 = source_length1;
	_tmp12_ = length;
	memcpy (_tmp10_, _tmp11_, (gsize) _tmp12_);
	_tmp13_ = length;
	*destination_length1 = _tmp13_;
	_tmp14_ = *destination_length1;
	result = length;
	return result;
}


gpointer* fso_framework_utility_listToArray (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GList* list, int* result_length1) {
	gpointer* result = NULL;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	gpointer* _tmp2_ = NULL;
	gpointer* a;
	gint a_length1;
	gint _a_size_;
	gint n;
	GList* _tmp3_;
	gpointer* _tmp11_;
	gint _tmp11__length1;
	_tmp0_ = list;
	_tmp1_ = g_list_length (_tmp0_);
	_tmp2_ = g_new0 (gpointer, _tmp1_);
	a = _tmp2_;
	a_length1 = _tmp1_;
	_a_size_ = a_length1;
	n = 0;
	_tmp3_ = list;
	{
		GList* element_collection = NULL;
		GList* element_it = NULL;
		element_collection = _tmp3_;
		for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
			gpointer _tmp4_;
			gpointer element = NULL;
			_tmp4_ = ((element_it->data != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) element_it->data) : ((gpointer) element_it->data);
			element = _tmp4_;
			{
				gpointer* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gconstpointer _tmp7_;
				gpointer _tmp8_;
				gpointer _tmp9_;
				gint _tmp10_;
				_tmp5_ = a;
				_tmp5__length1 = a_length1;
				_tmp6_ = n;
				_tmp7_ = element;
				_tmp8_ = ((_tmp7_ != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) _tmp7_) : ((gpointer) _tmp7_);
				_t_destroy_func0 (_tmp5_[_tmp6_]);
				_tmp5_[_tmp6_] = _tmp8_;
				_tmp9_ = _tmp5_[_tmp6_];
				_tmp10_ = n;
				n = _tmp10_ + 1;
				_t_destroy_func0 (element);
			}
		}
	}
	_tmp11_ = a;
	_tmp11__length1 = a_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}


static void fso_framework_network_textForUri_data_free (gpointer _data) {
	fso_framework_network_textForUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->servername);
	_g_free0 (_data_->uri);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (fso_framework_network_textForUriData, _data_);
}


void fso_framework_network_textForUri (const gchar* servername, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	fso_framework_network_textForUriData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (fso_framework_network_textForUriData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, fso_framework_network_textForUri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_network_textForUri_data_free);
	_tmp0_ = servername;
	_tmp1_ = g_strdup (_tmp0_);
	_data_->servername = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = g_strdup (_tmp2_);
	_data_->uri = _tmp3_;
	fso_framework_network_textForUri_co (_data_);
}


gchar** fso_framework_network_textForUri_finish (GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	fso_framework_network_textForUriData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void fso_framework_network_textForUri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	fso_framework_network_textForUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	fso_framework_network_textForUri_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean fso_framework_network_textForUri_co (fso_framework_network_textForUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->_result_ = _data_->_tmp0_;
	_data_->_result__length1 = 0;
	_data_->__result__size_ = _data_->_result__length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_resolver_get_default ();
	_data_->resolver = _data_->_tmp1_;
	_data_->addresses = NULL;
	{
		_data_->_tmp2_ = _data_->resolver;
		_data_->_tmp3_ = _data_->servername;
		_data_->_state_ = 1;
		g_resolver_lookup_by_name_async (_data_->_tmp2_, _data_->_tmp3_, NULL, fso_framework_network_textForUri_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_resolver_lookup_by_name_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_data_->addresses = _data_->_tmp5_;
	}
	goto __finally18;
	__catch18_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = fso_framework_theLogger;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = string_to_string (_data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strconcat ("Could not resolve server address ", _data_->_tmp9_, NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		fso_framework_logger_warning (_data_->_tmp6_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp11_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12__length1 = 0;
		_data_->result_length1 = _data_->_tmp12__length1;
		_data_->result = _data_->_tmp12_;
		_g_error_free0 (_data_->e);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally18:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->addresses;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_list_nth_data (_data_->_tmp13_, (guint) 0);
	_data_->_tmp15_ = _g_object_ref0 ((GInetAddress*) _data_->_tmp14_);
	_data_->serveraddr = _data_->_tmp15_;
	_data_->_tmp16_ = fso_framework_theLogger;
	_data_->_tmp17_ = _data_->servername;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = string_to_string (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->serveraddr;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_inet_address_to_string (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_strconcat ("Resolved ", _data_->_tmp18_, " to ", _data_->_tmp21_, NULL);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = FALSE;
	_data_->_tmp24_ = fso_framework_logger_debug (_data_->_tmp16_, _data_->_tmp23_);
	g_assert (_data_->_tmp24_);
	_g_free0 (_data_->_tmp23_);
	_g_free0 (_data_->_tmp21_);
	_data_->_tmp25_ = _data_->serveraddr;
	_data_->_tmp26_ = (GInetSocketAddress*) g_inet_socket_address_new (_data_->_tmp25_, (guint16) 80);
	_data_->socket = _data_->_tmp26_;
	_data_->_tmp27_ = g_socket_client_new ();
	_data_->client = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->client;
	_data_->_tmp29_ = _data_->socket;
	_data_->_state_ = 2;
	g_socket_client_connect_async (_data_->_tmp28_, (GSocketConnectable*) _data_->_tmp29_, NULL, fso_framework_network_textForUri_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = g_socket_client_connect_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
	_data_->conn = _data_->_tmp30_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->socket);
		_g_object_unref0 (_data_->serveraddr);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = fso_framework_theLogger;
	_data_->_tmp32_ = _data_->serveraddr;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = g_inet_address_to_string (_data_->_tmp32_);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = g_strconcat ("Connected to ", _data_->_tmp34_, NULL);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = FALSE;
	_data_->_tmp37_ = fso_framework_logger_debug (_data_->_tmp31_, _data_->_tmp36_);
	g_assert (_data_->_tmp37_);
	_g_free0 (_data_->_tmp36_);
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp38_ = _data_->uri;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = string_to_string (_data_->_tmp38_);
	_data_->_tmp40_ = _data_->servername;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = string_to_string (_data_->_tmp40_);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = g_strconcat ("GET ", _data_->_tmp39_, " HTTP/1.1\r\nHost: ", _data_->_tmp41_, "\r\nConnection: close\r\n\r\n", NULL);
	_data_->message = _data_->_tmp42_;
	_data_->_tmp43_ = _data_->conn;
	_data_->_tmp44_ = g_io_stream_get_output_stream ((GIOStream*) _data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = _data_->message;
	_data_->_tmp47_ = string_get_data (_data_->_tmp46_, &_data_->_tmp47__length1);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp48__length1 = _data_->_tmp47__length1;
	_data_->_state_ = 3;
	g_output_stream_write_async (_data_->_tmp45_, _data_->_tmp48_, (gsize) _data_->_tmp48__length1, G_PRIORITY_DEFAULT, NULL, fso_framework_network_textForUri_ready, _data_);
	return FALSE;
	_state_3:
	g_output_stream_write_finish (_data_->_tmp45_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->conn);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->socket);
		_g_object_unref0 (_data_->serveraddr);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp49_ = fso_framework_theLogger;
	_data_->_tmp50_ = FALSE;
	_data_->_tmp50_ = fso_framework_logger_debug (_data_->_tmp49_, "Wrote request");
	g_assert (_data_->_tmp50_);
	_data_->_tmp51_ = _data_->conn;
	_data_->_tmp52_ = g_socket_connection_get_socket (_data_->_tmp51_);
	_data_->_tmp53_ = _data_->_tmp52_;
	g_socket_set_blocking (_data_->_tmp53_, TRUE);
	_data_->_tmp54_ = _data_->conn;
	_data_->_tmp55_ = g_io_stream_get_input_stream ((GIOStream*) _data_->_tmp54_);
	_data_->_tmp56_ = _data_->_tmp55_;
	_data_->_tmp57_ = g_data_input_stream_new (_data_->_tmp56_);
	_data_->input = _data_->_tmp57_;
	_data_->_tmp58_ = _data_->input;
	_data_->_state_ = 4;
	g_data_input_stream_read_line_async (_data_->_tmp58_, 0, NULL, fso_framework_network_textForUri_ready, _data_);
	return FALSE;
	_state_4:
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = g_data_input_stream_read_line_finish (_data_->_tmp58_, _data_->_res_, NULL, &_data_->_inner_error_);
	_data_->_tmp60_ = _data_->_tmp59_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->input);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->conn);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->socket);
		_g_object_unref0 (_data_->serveraddr);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp61_ = _data_->_tmp60_;
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = string_strip (_data_->_tmp61_);
	_data_->_tmp63_ = _data_->_tmp62_;
	_g_free0 (_data_->_tmp61_);
	_data_->line = _data_->_tmp63_;
	_data_->_tmp64_ = fso_framework_theLogger;
	_data_->_tmp65_ = _data_->line;
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = string_to_string (_data_->_tmp65_);
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = g_strconcat ("Received status line: ", _data_->_tmp66_, NULL);
	_data_->_tmp68_ = _data_->_tmp67_;
	_data_->_tmp69_ = FALSE;
	_data_->_tmp69_ = fso_framework_logger_debug (_data_->_tmp64_, _data_->_tmp68_);
	g_assert (_data_->_tmp69_);
	_g_free0 (_data_->_tmp68_);
	_data_->_tmp70_ = _data_->line;
	_data_->_tmp71_ = FALSE;
	_data_->_tmp71_ = g_str_has_prefix (_data_->_tmp70_, "HTTP/1.1 200 OK");
	if (!_data_->_tmp71_) {
		_data_->_tmp72_ = NULL;
		_data_->_tmp72__length1 = 0;
		_data_->result_length1 = _data_->_tmp72__length1;
		_data_->result = _data_->_tmp72_;
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->input);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->conn);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->socket);
		_g_object_unref0 (_data_->serveraddr);
		__g_list_free__g_object_unref0_0 (_data_->addresses);
		_g_object_unref0 (_data_->resolver);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp75_ = _data_->line;
		if (_data_->_tmp75_ != NULL) {
			_data_->_tmp76_ = _data_->line;
			_data_->_tmp74_ = g_strcmp0 (_data_->_tmp76_, "\r") != 0;
		} else {
			_data_->_tmp74_ = FALSE;
		}
		_data_->_tmp77_ = _data_->_tmp74_;
		if (_data_->_tmp77_) {
			_data_->_tmp78_ = _data_->line;
			_data_->_tmp73_ = g_strcmp0 (_data_->_tmp78_, "\r\n") != 0;
		} else {
			_data_->_tmp73_ = FALSE;
		}
		_data_->_tmp79_ = _data_->_tmp73_;
		if (!_data_->_tmp79_) {
			break;
		}
		_data_->_tmp80_ = _data_->input;
		_data_->_state_ = 5;
		g_data_input_stream_read_line_async (_data_->_tmp80_, 0, NULL, fso_framework_network_textForUri_ready, _data_);
		return FALSE;
		_state_5:
		_data_->_tmp81_ = NULL;
		_data_->_tmp81_ = g_data_input_stream_read_line_finish (_data_->_tmp80_, _data_->_res_, NULL, &_data_->_inner_error_);
		_data_->_tmp82_ = _data_->_tmp81_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->line);
			_g_object_unref0 (_data_->input);
			_g_free0 (_data_->message);
			_g_object_unref0 (_data_->conn);
			_g_object_unref0 (_data_->client);
			_g_object_unref0 (_data_->socket);
			_g_object_unref0 (_data_->serveraddr);
			__g_list_free__g_object_unref0_0 (_data_->addresses);
			_g_object_unref0 (_data_->resolver);
			_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->line);
		_data_->line = _data_->_tmp82_;
		_data_->_tmp83_ = _data_->line;
		if (_data_->_tmp83_ != NULL) {
			_data_->_tmp84_ = fso_framework_theLogger;
			_data_->_tmp85_ = _data_->line;
			_data_->_tmp86_ = NULL;
			_data_->_tmp86_ = g_strescape (_data_->_tmp85_, "");
			_data_->_tmp87_ = _data_->_tmp86_;
			_data_->_tmp88_ = NULL;
			_data_->_tmp88_ = string_to_string (_data_->_tmp87_);
			_data_->_tmp89_ = NULL;
			_data_->_tmp89_ = g_strconcat ("Received header line: ", _data_->_tmp88_, NULL);
			_data_->_tmp90_ = _data_->_tmp89_;
			_data_->_tmp91_ = FALSE;
			_data_->_tmp91_ = fso_framework_logger_debug (_data_->_tmp84_, _data_->_tmp90_);
			g_assert (_data_->_tmp91_);
			_g_free0 (_data_->_tmp90_);
			_g_free0 (_data_->_tmp87_);
		}
	}
	while (TRUE) {
		_data_->_tmp92_ = _data_->line;
		if (!(_data_->_tmp92_ != NULL)) {
			break;
		}
		_data_->_tmp93_ = _data_->input;
		_data_->_state_ = 6;
		g_data_input_stream_read_line_async (_data_->_tmp93_, 0, NULL, fso_framework_network_textForUri_ready, _data_);
		return FALSE;
		_state_6:
		_data_->_tmp94_ = NULL;
		_data_->_tmp94_ = g_data_input_stream_read_line_finish (_data_->_tmp93_, _data_->_res_, NULL, &_data_->_inner_error_);
		_data_->_tmp95_ = _data_->_tmp94_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->line);
			_g_object_unref0 (_data_->input);
			_g_free0 (_data_->message);
			_g_object_unref0 (_data_->conn);
			_g_object_unref0 (_data_->client);
			_g_object_unref0 (_data_->socket);
			_g_object_unref0 (_data_->serveraddr);
			__g_list_free__g_object_unref0_0 (_data_->addresses);
			_g_object_unref0 (_data_->resolver);
			_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->line);
		_data_->line = _data_->_tmp95_;
		_data_->_tmp99_ = _data_->line;
		if (_data_->_tmp99_ != NULL) {
			_data_->_tmp100_ = _data_->line;
			_data_->_tmp98_ = g_strcmp0 (_data_->_tmp100_, "\r") != 0;
		} else {
			_data_->_tmp98_ = FALSE;
		}
		_data_->_tmp101_ = _data_->_tmp98_;
		if (_data_->_tmp101_) {
			_data_->_tmp102_ = _data_->line;
			_data_->_tmp97_ = g_strcmp0 (_data_->_tmp102_, "\r\n") != 0;
		} else {
			_data_->_tmp97_ = FALSE;
		}
		_data_->_tmp103_ = _data_->_tmp97_;
		if (_data_->_tmp103_) {
			_data_->_tmp104_ = _data_->line;
			_data_->_tmp96_ = g_strcmp0 (_data_->_tmp104_, "") != 0;
		} else {
			_data_->_tmp96_ = FALSE;
		}
		_data_->_tmp105_ = _data_->_tmp96_;
		if (_data_->_tmp105_) {
			_data_->_tmp106_ = fso_framework_theLogger;
			_data_->_tmp107_ = _data_->line;
			_data_->_tmp108_ = NULL;
			_data_->_tmp108_ = string_to_string (_data_->_tmp107_);
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = g_strconcat ("Received content line: ", _data_->_tmp108_, NULL);
			_data_->_tmp110_ = _data_->_tmp109_;
			_data_->_tmp111_ = FALSE;
			_data_->_tmp111_ = fso_framework_logger_debug (_data_->_tmp106_, _data_->_tmp110_);
			g_assert (_data_->_tmp111_);
			_g_free0 (_data_->_tmp110_);
			_data_->_tmp112_ = _data_->_result_;
			_data_->_tmp112__length1 = _data_->_result__length1;
			_data_->_tmp113_ = _data_->line;
			_data_->_tmp114_ = NULL;
			_data_->_tmp114_ = string_strip (_data_->_tmp113_);
			_vala_array_add10 (&_data_->_result_, &_data_->_result__length1, &_data_->__result__size_, _data_->_tmp114_);
		}
	}
	_data_->_tmp115_ = _data_->_result_;
	_data_->_tmp115__length1 = _data_->_result__length1;
	_data_->result_length1 = _data_->_tmp115__length1;
	_data_->result = _data_->_tmp115_;
	_g_free0 (_data_->line);
	_g_object_unref0 (_data_->input);
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->conn);
	_g_object_unref0 (_data_->client);
	_g_object_unref0 (_data_->socket);
	_g_object_unref0 (_data_->serveraddr);
	__g_list_free__g_object_unref0_0 (_data_->addresses);
	_g_object_unref0 (_data_->resolver);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->line);
	_g_object_unref0 (_data_->input);
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->conn);
	_g_object_unref0 (_data_->client);
	_g_object_unref0 (_data_->socket);
	_g_object_unref0 (_data_->serveraddr);
	__g_list_free__g_object_unref0_0 (_data_->addresses);
	_g_object_unref0 (_data_->resolver);
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



