# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationEntityBaseContract(Model):
    """Api Operation Entity Base Contract details.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters:
     list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML
     formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies
    :type policies: str
    """

    _validation = {
        'description': {'max_length': 1000},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
    }

    def __init__(self, *, template_parameters=None, description: str=None, request=None, responses=None, policies: str=None, **kwargs) -> None:
        super(OperationEntityBaseContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies
