% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Shifted_Lognormal}
\alias{Shifted_Lognormal}
\alias{dshifted_lnorm}
\alias{pshifted_lnorm}
\alias{qshifted_lnorm}
\alias{rshifted_lnorm}
\title{The Shifted Log Normal Distribution}
\usage{
dshifted_lnorm(x, meanlog = 0, sdlog = 1, shift = 0, log = FALSE)

pshifted_lnorm(
  q,
  meanlog = 0,
  sdlog = 1,
  shift = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

qshifted_lnorm(
  p,
  meanlog = 0,
  sdlog = 1,
  shift = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

rshifted_lnorm(n, meanlog = 0, sdlog = 1, shift = 0)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{meanlog}{Vector of means.}

\item{sdlog}{Vector of standard deviations.}

\item{shift}{Vector of shifts.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x).
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{p}{Vector of probabilities.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Density, distribution function, quantile function and random generation
for the shifted log normal distribution with mean \code{meanlog},
standard deviation \code{sdlog}, and shift parameter \code{shift}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
