% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_louvain}
\alias{cluster_louvain}
\alias{multilevel.community}
\title{Finding community structure by multi-level optimization of modularity}
\usage{
cluster_louvain(graph, weights = NULL)
}
\arguments{
\item{graph}{The input graph.}

\item{weights}{Optional positive weight vector.  If the graph has a
\code{weight} edge attribute, then this is used by default. Supply \code{NA}
here if the graph has a \code{weight} edge attribute, but you want to ignore
it. Larger edge weights correspond to stronger connections.}
}
\value{
\code{cluster_louvain} returns a \code{\link{communities}}
object, please see the \code{\link{communities}} manual page for details.
}
\description{
This function implements the multi-level modularity optimization algorithm
for finding community structure, see references below. It is based on the
modularity measure and a hierarchial approach.
}
\details{
This function implements the multi-level modularity optimization algorithm
for finding community structure, see VD Blondel, J-L Guillaume, R Lambiotte
and E Lefebvre: Fast unfolding of community hierarchies in large networks,
\url{http://arxiv.org/abs/arXiv:0803.0476} for the details.

It is based on the modularity measure and a hierarchial approach.
Initially, each vertex is assigned to a community on its own. In every step,
vertices are re-assigned to communities in a local, greedy way: each vertex
is moved to the community with which it achieves the highest contribution to
modularity. When no vertices can be reassigned, each community is considered
a vertex on its own, and the process starts again with the merged
communities. The process stops when there is only a single vertex left or
when the modularity cannot be increased any more in a step.

This function was contributed by Tom Gregorovic.
}
\examples{

# This is so simple that we will have only one level
g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1,6, 1,11, 6, 11))
cluster_louvain(g)

}
\references{
Vincent D. Blondel, Jean-Loup Guillaume, Renaud Lambiotte,
Etienne Lefebvre: Fast unfolding of communities in large networks. J. Stat.
Mech. (2008) P10008
}
\seealso{
See \code{\link{communities}} for extracting the membership,
modularity scores, etc. from the results.

Other community detection algorithms: \code{\link{cluster_walktrap}},
\code{\link{cluster_spinglass}},
\code{\link{cluster_leading_eigen}},
\code{\link{cluster_edge_betweenness}},
\code{\link{cluster_fast_greedy}},
\code{\link{cluster_label_prop}}
}
\author{
Tom Gregorovic, Tamas Nepusz \email{ntamas@gmail.com}
}
\keyword{graphs}
