% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{stri_opts_fixed}
\alias{stri_opts_fixed}
\title{Generate a List with Fixed Pattern Search Engine's Settings}
\usage{
stri_opts_fixed(case_insensitive = FALSE, overlap = FALSE, ...)
}
\arguments{
\item{case_insensitive}{logical; enable simple case insensitive matching}

\item{overlap}{logical; enable overlapping matches detection in certain functions}

\item{...}{any other arguments to this function are purposely ignored}
}
\value{
Returns a named list object.
}
\description{
A convenience function used to tune up the \code{stri_*_fixed} functions'
behavior, see \link{stringi-search-fixed}.
}
\details{
Case-insensitive matching uses a simple, single-code point case mapping
(via ICU's \code{u_toupper()} function).
Full case mappings should be used whenever possible because they produce
better results by working on whole strings. They take into account
the string context and the language and can map to a result string with
a different length as appropriate, see \link{stringi-search-coll}.

Searching for overlapping pattern matches works in case of the
\code{\link{stri_extract_all_fixed}}, \code{\link{stri_locate_all_fixed}},
and \code{\link{stri_count_fixed}} functions.
}
\examples{
stri_detect_fixed("ala", "ALA") # case-sensitive by default
stri_detect_fixed("ala", "ALA", opts_fixed=stri_opts_fixed(case_insensitive=TRUE))
stri_detect_fixed("ala", "ALA", case_insensitive=TRUE) # equivalent
}
\references{
\emph{C/POSIX Migration} -- ICU User Guide,
\url{http://userguide.icu-project.org/posix#case_mappings}
}
\seealso{
Other search_fixed: \code{\link{stringi-search-fixed}},
  \code{\link{stringi-search}}
}
