8.1 Listas

# Listas

En esta sección miraremos una Estructura de Datos muy útil: la Lista.
Ya la vimos -brevemente- en la sección de aleatoriedad, cuando de una
lista de notas elegía al azar las notas a tocar:


```
play choose([50, 55, 62])
```

Ahora también exploraremos listas que que representan acordes y escalas.
Primero repasemos cómo tocar un acorde. Recuerda que si no usamos `sleep`,
todos los sonidos suceden al mismo tiempo:


```
play 52
play 55
play 59
```

Veamos otras maneras de representar este código.

## Ejecutando una Lista

Una opción es colocar todas las notas en una lista: `[52, 55, 59]`.
Nuestro amigable `play` es lo suficientemente listo para entender cómo
tocar una lista de notas. Probemos:


```
play [52, 55, 59]
```

Ohh, eso ya está mejor para leer. El tocar un listado de notas no significa
que no puedas usar los otros parámetros, normalmente:



```
play [52, 55, 59], amp: 0.3
```

Por supuesto, puedes usar los nombres tradicionales de notas en vez de
números MIDI


```
play [:E3, :G3, :B3]
```

Ahora, esos suertudos de ustedes con estudios en teoría musical, podrán
reconocer que el acorde es *Mi menor* tocado en la 3ra octava.


## Accediendo a una Lista 

Otro aspecto útil de una lista es la habilidad de obtener información de 
la misma. Puede sonar extraño, pero es igual a alguien pidiéndote que
pases a la página 23 de un libro. Con una lista, dirías, ¿qué elemento hay
en el índice 23? Lo único diferente es que en índices de programación se 
comienza con 0 y no con 1.
Con índices de listas no contamos 1, 2, 3... sino que 0, 1, 2...

Veamos eso en mayor detalle en esta lista:

```
[52, 55, 59]
```

No hay algo espcialmente de susto en ello. Ahora, ¿qué es el segundo
elemento en esa lista? Si, claro, es `55`. Fácil. Veamos si la computadora
puede respondernoslo, también:


```
puts [52, 55, 59][1]
```

Si se mira algo raro, confía en mí, no lo es. Hay tres partes en la línea
de arriba: la palabra `puts`, nuestra lista `52, 55, 59` y nuestro índice
`[1]`. Primero pedimos `puts` para que Sonic Pi imprima la respuesta en la
bitácora. Después, le damos nuestra lista y finalmente nuestro índice le
pide el segundo elemento. Necesitamos rodear nuestro índice con paréntesis
cuadrados y ya que el conteo comienza en `0`, el índice para el segundo 
elemento es `1`. Mira:


```
# indexes:  0   1   2
           [52, 55, 59]
```

Prueba con `puts [52, 55, 59][1]` y verás `55` en la bitácora.
Cambia el índice `1` a otros índices, intenta con listas más largas en tu
próximo código. Por ejemplo, estructuras musicales que podrían representarse
como series de números






