/*	$NetBSD$	*/

/*
 * Copyright (c) 1997 Michael L. Hitch.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed for the NetBSD Project
 *	by Michael L. Hitch.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

struct cosc_softc {
	struct ncr53c9x_softc	sc_ncr53c9x;	/* glue to MI code */

	irqhandler_t	sc_ih;			/* Interrupt chain struct */

	volatile u_char *sc_reg;		/* the registers */
/*	volatile u_char *sc_led;*/
	volatile u_char *sc_term;
/*	volatile u_char *sc_status;*/
/*	volatile u_char *sc_inten;*/

	int		sc_active;		/* Pseudo-DMA state vars */
	int		sc_piomode;
	int		sc_datain;
	size_t		sc_dmasize;
	char		**sc_dmaaddr;
	size_t		*sc_pdmalen;
};

#define COSC_CONFIG_CONTROL_REG1	0x0ff0
#define COSC_CONFIG_CONTROL_REG1_MASK	0x97
#define COSC_CONFIG_CONTROL_REG2	0x0ff4
#define COSC_CONFIG_CONTROL_REG2_MASK	0x07
#define COSC_CONFIG_CONTROL_REG3	0x0ff8
#define COSC_CONFIG_CONTROL_REG3_MASK	0x83
#define COSC_CONFIG_CONTROL_REG4	0x0ffc
#define COSC_CONFIG_CONTROL_REG4_MASK	0xec
#define COSC_CONFIG_TERMINATION		0x1000
#define COSC_CONFIG_TERMINATION_ON	0x01
#define COSC_CONFIG_FIRST_SCANNED	0x1040	/* Used by RiscOS */
#define COSC_CONFIG_INC_FURTHER_PARTS	0x1048	/* Used by RiscOS */
#define COSC_CONFIG_SYNCH_MODE		0x1050
#define COSC_CONFIG_SYNCH_MODE_ON	0x01
#define COSC_CONFIG_SHUTDOWN		0x1054	/* Used by RiscOS */
#define COSC_CONFIG_SHUTDOWN_SPINDOWN	0x01	/* Used by RiscOS */
#define COSC_CONFIG_SHUTDOWN_EJECT	0x02	/* Used by RiscOS */
#define COSC_CONFIG_DELAY_REMOVABLE	0x105c	/* Used by RiscOS */
#define COSC_CONFIG_DELAY_HARDDISC	0x1060	/* Used by RiscOS */
#define COSC_CONFIG_DELAY_BOOT		0x1064	/* Used by RiscOS */
#define COSC_CONFIG_CDROM		0x1068	/* Used by RiscOS */

#define COSC_TERMINATION_CONTROL	0x2600
#define COSC_TERMINATION_ON		0x00
#define COSC_TERMINATION_OFF		0x01
#define COSC_REGISTER_00		0x2800
#define COSC_REGISTER_01		0x2a00
#define COSC_PAGE_REGISTER		0x3000

#define COSC_ESCOFFSET_BASE		0x3c00
#define COSC_FAS_REG_SPACING		4
