/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.ReferenceChain;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.server.QueryHandler;
import com.sun.tools.hat.internal.util.ArraySorter;
import com.sun.tools.hat.internal.util.Comparer;

class RootsQuery
extends QueryHandler {
    private boolean includeWeak;

    public RootsQuery(boolean bl) {
        this.includeWeak = bl;
    }

    public void run() {
        long l = this.parseHex(this.query);
        JavaHeapObject javaHeapObject = this.snapshot.findThing(l);
        if (javaHeapObject == null) {
            this.startHtml("Object not found for rootset");
            this.error("object not found");
            this.endHtml();
            return;
        }
        if (this.includeWeak) {
            this.startHtml("Rootset references to " + javaHeapObject + " (includes weak refs)");
        } else {
            this.startHtml("Rootset references to " + javaHeapObject + " (excludes weak refs)");
        }
        this.out.flush();
        Object[] objectArray = this.snapshot.rootsetReferencesTo(javaHeapObject, this.includeWeak);
        ArraySorter.sort(objectArray, new Comparer(){

            public int compare(Object object, Object object2) {
                ReferenceChain referenceChain = (ReferenceChain)object;
                ReferenceChain referenceChain2 = (ReferenceChain)object2;
                Root root = referenceChain.getObj().getRoot();
                Root root2 = referenceChain2.getObj().getRoot();
                int n = root.getType() - root2.getType();
                if (n != 0) {
                    return -n;
                }
                return referenceChain.getDepth() - referenceChain2.getDepth();
            }
        });
        this.out.print("<h1>References to ");
        this.printThing(javaHeapObject);
        this.out.println("</h1>");
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Root root = ((ReferenceChain)object).getObj().getRoot();
            if (root.getType() != n) {
                n = root.getType();
                this.out.print("<h2>");
                this.print(root.getTypeName() + " References");
                this.out.println("</h2>");
            }
            this.out.print("<h3>");
            this.printRoot(root);
            if (root.getReferer() != null) {
                this.out.print("<small> (from ");
                this.printThingAnchorTag(root.getReferer().getId());
                this.print(root.getReferer().toString());
                this.out.print(")</a></small>");
            }
            this.out.print(" :</h3>");
            while (object != null) {
                ReferenceChain referenceChain = ((ReferenceChain)object).getNext();
                JavaHeapObject javaHeapObject2 = ((ReferenceChain)object).getObj();
                this.print("--> ");
                this.printThing(javaHeapObject2);
                if (referenceChain != null) {
                    this.print(" (" + javaHeapObject2.describeReferenceTo(referenceChain.getObj(), this.snapshot) + ":)");
                }
                this.out.println("<br>");
                object = referenceChain;
            }
        }
        this.out.println("<h2>Other queries</h2>");
        if (this.includeWeak) {
            this.printAnchorStart();
            this.out.print("roots/");
            this.printHex(l);
            this.out.print("\">");
            this.out.println("Exclude weak refs</a><br>");
            this.endHtml();
        }
        if (!this.includeWeak) {
            this.printAnchorStart();
            this.out.print("allRoots/");
            this.printHex(l);
            this.out.print("\">");
            this.out.println("Include weak refs</a><br>");
        }
    }
}

