/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.tools.apt.Main;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.Processor;
import com.sun.tools.internal.ws.processor.ProcessorAction;
import com.sun.tools.internal.ws.processor.ProcessorNotificationListener;
import com.sun.tools.internal.ws.processor.config.ClassModelInfo;
import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.processor.config.parser.Reader;
import com.sun.tools.internal.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.internal.ws.processor.generator.JAXBTypeGenerator;
import com.sun.tools.internal.ws.processor.generator.SeiGenerator;
import com.sun.tools.internal.ws.processor.generator.ServiceGenerator;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceAP;
import com.sun.tools.internal.ws.processor.util.ClientProcessorEnvironment;
import com.sun.tools.internal.ws.processor.util.GeneratedFileInfo;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironmentBase;
import com.sun.tools.internal.ws.util.ForkEntityResolver;
import com.sun.tools.internal.ws.util.JavaCompilerHelper;
import com.sun.tools.internal.ws.util.ToolBase;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.modeler.RuntimeModeler;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.internal.ws.wsdl.writer.WSDLOutputResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileTool
extends ToolBase
implements ProcessorNotificationListener,
AnnotationProcessorFactory {
    static final Collection<String> supportedOptions = Collections.unmodifiableSet(new HashSet());
    static Collection<String> supportedAnnotations;
    private AnnotationProcessorContext context;
    private WebServiceAP webServiceAP;
    private int round = 0;
    protected Properties properties;
    protected ProcessorEnvironment environment;
    protected Configuration configuration;
    protected ProcessorNotificationListener listener;
    protected Processor processor;
    protected Map<String, ProcessorAction> actions;
    protected List<String> inputFiles = new ArrayList<String>();
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected boolean doNothing = false;
    protected boolean compilerDebug = false;
    protected boolean compilerOptimize = false;
    protected boolean verbose = false;
    protected boolean keepGenerated = false;
    protected boolean doNotOverWrite = false;
    protected boolean extensions = false;
    protected String userClasspath = null;
    protected Set<String> bindingFiles = new HashSet<String>();
    protected boolean genWsdl = false;
    protected String protocol = "soap1.1";
    protected boolean protocolSet = false;
    protected String transport = "http";
    protected static final String SOAP11 = "soap1.1";
    protected static final String X_SOAP12 = "Xsoap1.2";
    protected static final String HTTP = "http";
    protected static final String WSIMPORT = "wsimport";
    protected static final String WSGEN = "wsgen";
    protected static final String SOAP11_ID = "http://schemas.xmlsoap.org/wsdl/soap/http";
    protected static final String SOAP12_ID = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    protected static final String VALID_PROTOCOLS = "soap1.1, Xsoap1.2";
    protected static final String VALID_TRANSPORTS = "http";
    protected String targetVersion = null;
    protected String wsdlLocation;
    protected String defaultPackage;
    protected String catalog;
    protected QName serviceName;
    protected QName portName;
    protected static final String PORTNAME_OPTION = "-portname";
    protected static final String SERVICENAME_OPTION = "-servicename";
    protected EntityResolver entityResolver;

    public CompileTool(OutputStream outputStream, String string) {
        super(outputStream, string);
        this.listener = this;
    }

    @Override
    protected boolean parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string;
            if (stringArray[i].equals("")) {
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equals("-g")) {
                this.compilerDebug = true;
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equals("-verbose")) {
                this.verbose = true;
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equals("-b")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    string = stringArray[++i];
                    stringArray[i] = null;
                    this.bindingFiles.add(JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)string)));
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-b"));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-version")) {
                this.report(ToolVersion.VERSION.BUILD_VERSION);
                this.doNothing = true;
                stringArray[i] = null;
                return true;
            }
            if (stringArray[i].equals("-keep")) {
                this.keepGenerated = true;
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equals("-wsdllocation")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    this.wsdlLocation = stringArray[++i];
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-p")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    this.defaultPackage = stringArray[++i];
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-catalog")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    this.catalog = stringArray[++i];
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].equals(SERVICENAME_OPTION)) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    this.serviceName = QName.valueOf(stringArray[++i]);
                    if (this.serviceName.getNamespaceURI() == null || this.serviceName.getNamespaceURI().length() == 0) {
                        this.onError(this.getMessage("wsgen.servicename.missing.namespace", stringArray[i]));
                        this.usage();
                        return false;
                    }
                    if (this.serviceName.getLocalPart() == null || this.serviceName.getLocalPart().length() == 0) {
                        this.onError(this.getMessage("wsgen.servicename.missing.localname", stringArray[i]));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].equals(PORTNAME_OPTION)) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    stringArray[i] = null;
                    this.portName = QName.valueOf(stringArray[++i]);
                    if (this.portName.getNamespaceURI() == null || this.portName.getNamespaceURI().length() == 0) {
                        this.onError(this.getMessage("wsgen.portname.missing.namespace", stringArray[i]));
                        this.usage();
                        return false;
                    }
                    if (this.portName.getLocalPart() == null || this.portName.getLocalPart().length() == 0) {
                        this.onError(this.getMessage("wsgen.portname.missing.localname", stringArray[i]));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-d")) {
                if (i + 1 < stringArray.length) {
                    if (this.destDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-d"));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    this.destDir = new File(stringArray[++i]);
                    stringArray[i] = null;
                    if (this.destDir.exists()) continue;
                    this.onError(this.getMessage("wscompile.noSuchDirectory", this.destDir.getPath()));
                    this.usage();
                    return false;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-d"));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-r")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    if (this.nonclassDestDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-r"));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    this.nonclassDestDir = new File(stringArray[++i]);
                    stringArray[i] = null;
                    if (this.nonclassDestDir.exists()) continue;
                    this.onError(this.getMessage("wscompile.noSuchDirectory", this.nonclassDestDir.getPath()));
                    this.usage();
                    return false;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-r"));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-s")) {
                if (i + 1 < stringArray.length) {
                    if (this.sourceDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-s"));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    this.sourceDir = new File(stringArray[++i]);
                    stringArray[i] = null;
                    if (!this.sourceDir.exists()) {
                        this.onError(this.getMessage("wscompile.noSuchDirectory", this.sourceDir.getPath()));
                        this.usage();
                        return false;
                    }
                    this.keepGenerated = true;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-s"));
                this.usage();
                return false;
            }
            if (stringArray[i].equals("-classpath") || stringArray[i].equals("-cp")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < stringArray.length) {
                    if (this.userClasspath != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", stringArray[i]));
                        this.usage();
                        return false;
                    }
                    stringArray[i] = null;
                    this.userClasspath = stringArray[++i];
                    stringArray[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", stringArray[i]));
                this.usage();
                return false;
            }
            if (stringArray[i].startsWith("-httpproxy:")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                string = stringArray[i].substring(11);
                if (string.length() == 0) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                n = string.indexOf(58);
                if (n == -1) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", string);
                    System.setProperty("proxyPort", "8080");
                } else {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", string.substring(0, n));
                    System.setProperty("proxyPort", string.substring(n + 1));
                }
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].startsWith("-wsdl")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                    this.usage();
                    return false;
                }
                this.genWsdl = true;
                string = stringArray[i].substring(5);
                n = string.indexOf(58);
                if (n == 0) {
                    n = (string = string.substring(1)).indexOf(47);
                    if (n == -1) {
                        this.protocol = string;
                        this.transport = "http";
                    } else {
                        this.protocol = string.substring(0, n);
                        this.transport = string.substring(n + 1);
                    }
                    if (!CompileTool.isValidProtocol(this.protocol)) {
                        this.onError(this.getMessage("wsgen.invalid.protocol", this.protocol, VALID_PROTOCOLS));
                    }
                    this.protocolSet = true;
                    if (!CompileTool.isValidTransport(this.transport)) {
                        this.onError(this.getMessage("wsgen.invalid.transport", this.transport, "http"));
                    }
                }
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equals("-extension")) {
                this.extensions = true;
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].startsWith("-help")) {
                this.help();
                return false;
            }
            if (!stringArray[i].equals("-Xdonotoverwrite")) continue;
            if (this.program.equals(WSIMPORT)) {
                this.onError(this.getMessage("wscompile.invalidOption", stringArray[i]));
                this.usage();
                return false;
            }
            this.doNotOverWrite = true;
            stringArray[i] = null;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            if (string.startsWith("-")) {
                this.onError(this.getMessage("wscompile.invalidOption", string));
                this.usage();
                return false;
            }
            String string2 = string;
            if (this.program.equals(WSGEN) && !this.isValidWSGenClass(string2)) {
                return false;
            }
            this.inputFiles.add(string2);
        }
        if (this.inputFiles.isEmpty()) {
            this.onError(this.getMessage(this.program + ".missingFile"));
            this.usage();
            return false;
        }
        if (!this.extensions && this.hasExtensions()) {
            return false;
        }
        this.properties.put("bindingFiles", this.bindingFiles);
        if (!this.validateArguments()) {
            this.usage();
            return false;
        }
        return true;
    }

    protected boolean isValidWSGenClass(String string) {
        Class clazz = this.getClass(string);
        if (clazz == null) {
            this.onError(this.getMessage("wsgen.class.not.found", string));
            return false;
        }
        if (clazz.isEnum() || clazz.isInterface() || clazz.isPrimitive()) {
            this.onError(this.getMessage("wsgen.class.must.be.implementation.class", string));
            return false;
        }
        if (this.genWsdl) {
            BindingImpl bindingImpl = (BindingImpl)BindingImpl.getBinding(null, (Class)clazz, null, (boolean)false);
            if (!(bindingImpl instanceof SOAPBinding)) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.non.soap.binding", new Object[]{string, bindingImpl.getBindingId()}));
                return false;
            }
            SOAPBindingImpl sOAPBindingImpl = (SOAPBindingImpl)bindingImpl;
            if (!(!sOAPBindingImpl.getActualBindingId().equals(SOAP12_ID) && !sOAPBindingImpl.getActualBindingId().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || this.protocol.equals(X_SOAP12) && this.extensions)) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.soap12.binding", new Object[]{string, bindingImpl.getBindingId()}));
                return false;
            }
            if (sOAPBindingImpl.getActualBindingId().equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/") && !this.extensions) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.xsoap12.binding.wo.extention", new Object[]{string, bindingImpl.getBindingId()}));
                return false;
            }
        }
        return true;
    }

    protected boolean validateArguments() {
        if (!this.genWsdl) {
            if (this.serviceName != null) {
                this.onError(this.getMessage("wsgen.wsdl.arg.no.genwsdl", SERVICENAME_OPTION));
                return false;
            }
            if (this.portName != null) {
                this.onError(this.getMessage("wsgen.wsdl.arg.no.genwsdl", PORTNAME_OPTION));
                return false;
            }
        }
        return true;
    }

    protected boolean hasExtensions() {
        if (this.protocol.equalsIgnoreCase(X_SOAP12)) {
            this.onError(this.getMessage("wsgen.soap12.without.extension"));
            return true;
        }
        return false;
    }

    public static boolean isValidProtocol(String string) {
        return string.equalsIgnoreCase(SOAP11) || string.equalsIgnoreCase(X_SOAP12);
    }

    public static boolean isValidTransport(String string) {
        return string.equalsIgnoreCase("http");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        if (this.doNothing) {
            return;
        }
        try {
            this.beforeHook();
            if (this.entityResolver == null) {
                if (this.catalog != null && this.catalog.length() > 0) {
                    this.entityResolver = XmlUtil.createEntityResolver((URL)JAXWSUtils.getFileOrURL((String)this.catalog));
                }
            } else if (this.catalog != null && this.catalog.length() > 0) {
                EntityResolver entityResolver = XmlUtil.createEntityResolver((URL)JAXWSUtils.getFileOrURL((String)this.catalog));
                this.entityResolver = new ForkEntityResolver(entityResolver, this.entityResolver);
            }
            this.environment = this.createEnvironment();
            this.configuration = this.createConfiguration();
            this.setEnvironmentValues(this.environment);
            if (this.configuration.getModelInfo() instanceof ClassModelInfo) {
                this.buildModel(((ClassModelInfo)this.configuration.getModelInfo()).getClassName());
            } else {
                this.processor = new Processor(this.configuration, this.properties);
                this.configuration.getModelInfo().setEntityResolver(this.entityResolver);
                this.configuration.getModelInfo().setDefaultJavaPackage(this.defaultPackage);
                this.processor.runModeler();
                this.withModelHook();
                this.registerProcessorActions(this.processor);
                this.processor.runActions();
                if (this.environment.getErrorCount() == 0) {
                    this.compileGeneratedClasses();
                }
            }
            this.afterHook();
        }
        finally {
            if (!this.keepGenerated) {
                this.removeGeneratedFiles();
            }
            if (this.environment != null) {
                this.environment.shutdown();
            }
        }
    }

    protected void setEnvironmentValues(ProcessorEnvironment processorEnvironment) {
        int n = processorEnvironment.getFlags();
        n |= 2;
        if (this.verbose) {
            n |= 1;
        }
        processorEnvironment.setFlags(n);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.properties = new Properties();
        this.actions = new HashMap<String, ProcessorAction>();
        this.actions.put("service.generator", new ServiceGenerator());
        this.actions.put("remote.interface.impl.generator", new SeiGenerator());
        this.actions.put("custom.exception.generator", new CustomExceptionGenerator());
        this.actions.put("jaxb.type.generator", new JAXBTypeGenerator());
    }

    public void removeGeneratedFiles() {
        this.environment.deleteGeneratedFiles();
    }

    public void buildModel(String string) {
        this.context = new AnnotationProcessorContext();
        this.webServiceAP = new WebServiceAP(this, this.environment, this.properties, this.context);
        String string2 = this.environment.getClassPath();
        String[] stringArray = new String[]{"-d", this.destDir.getAbsolutePath(), "-classpath", string2, "-s", this.sourceDir.getAbsolutePath(), "-XclassesAsDecls", string};
        int n = Main.process((AnnotationProcessorFactory)this, stringArray);
        if (n != 0) {
            this.environment.error(this.getMessage("wscompile.compilationFailed"));
            return;
        }
        if (this.genWsdl) {
            BindingImpl bindingImpl;
            String string3 = this.destDir.getAbsolutePath() + File.pathSeparator + string2;
            URLClassLoader uRLClassLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(string3), this.getClass().getClassLoader());
            Class<?> clazz = null;
            try {
                clazz = uRLClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.environment.error(this.getMessage("wsgen.class.not.found", string));
            }
            String string4 = CompileTool.getBindingID(this.protocol);
            if (!this.protocolSet) {
                bindingImpl = (BindingImpl)BindingImpl.getBinding(null, clazz, null, (boolean)false);
                string4 = bindingImpl.getBindingId();
            }
            bindingImpl = new RuntimeModeler(clazz, this.serviceName, string4);
            bindingImpl.setClassLoader((ClassLoader)uRLClassLoader);
            if (this.portName != null) {
                bindingImpl.setPortName(this.portName);
            }
            RuntimeModel runtimeModel = bindingImpl.buildRuntimeModel();
            WSDLGenerator wSDLGenerator = new WSDLGenerator(runtimeModel, new WSDLOutputResolver(){

                public Result getWSDLOutput(String string) {
                    File file = new File(CompileTool.this.nonclassDestDir, string);
                    StreamResult streamResult = new StreamResult();
                    try {
                        streamResult = new StreamResult(new FileOutputStream(file));
                        streamResult.setSystemId(file.toString().replace('\\', '/'));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        CompileTool.this.environment.error(CompileTool.this.getMessage("wsgen.could.not.create.file", file.toString()));
                    }
                    return streamResult;
                }

                public Result getSchemaOutput(String string, String string2) {
                    if (string.equals("")) {
                        return null;
                    }
                    return this.getWSDLOutput(string2);
                }

                public Result getAbstractWSDLOutput(Holder<String> holder) {
                    return this.getWSDLOutput((String)holder.value);
                }

                public Result getSchemaOutput(String string, Holder<String> holder) {
                    return this.getSchemaOutput(string, (String)holder.value);
                }
            }, string4);
            wSDLGenerator.doGeneration();
        }
    }

    public static String getBindingID(String string) {
        if (string.equals(SOAP11)) {
            return SOAP11_ID;
        }
        if (string.equals(X_SOAP12)) {
            return SOAP12_ID;
        }
        return null;
    }

    @Override
    public void runProcessorActions() {
        if (!(this.configuration.getModelInfo() instanceof ClassModelInfo)) {
            this.onError(this.getMessage("wscompile.classmodelinfo.expected", new Object[]{this.configuration.getModelInfo()}));
            return;
        }
        Model model = this.context.getSEIContext(((ClassModelInfo)this.configuration.getModelInfo()).getClassName()).getModel();
        this.processor = new Processor(this.configuration, this.properties, model);
        this.withModelHook();
        this.registerProcessorActions(this.processor);
        this.processor.runActions();
    }

    protected String getSourceVersion() {
        if (this.targetVersion == null) {
            return "2.0";
        }
        return this.targetVersion;
    }

    protected void withModelHook() {
    }

    protected void afterHook() {
    }

    protected void compileGeneratedClasses() {
        String[] stringArray;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = this.environment.getGeneratedFiles();
        while (object2.hasNext()) {
            object = (GeneratedFileInfo)object2.next();
            stringArray = ((GeneratedFileInfo)object).getFile();
            if (!stringArray.exists() || !stringArray.getName().endsWith(".java")) continue;
            arrayList.add(stringArray.getAbsolutePath());
        }
        if (arrayList.size() > 0) {
            object2 = this.destDir.getAbsolutePath();
            object = this.createClasspathString();
            stringArray = new String[4 + (this.compilerDebug ? 1 : 0) + (this.compilerOptimize ? 1 : 0) + arrayList.size()];
            stringArray[0] = "-d";
            stringArray[1] = object2;
            stringArray[2] = "-classpath";
            stringArray[3] = object;
            int n = 4;
            if (this.compilerDebug) {
                stringArray[n++] = "-g";
            }
            if (this.compilerOptimize) {
                stringArray[n++] = "-O";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[n + i] = (String)arrayList.get(i);
            }
            JavaCompilerHelper javaCompilerHelper = new JavaCompilerHelper(this.out);
            boolean bl = javaCompilerHelper.compile(stringArray);
            if (!bl) {
                this.environment.error(this.getMessage("wscompile.compilationFailed"));
            }
        }
    }

    protected ProcessorAction getAction(String string) {
        return this.actions.get(string);
    }

    protected String createClasspathString() {
        if (this.userClasspath == null) {
            this.userClasspath = "";
        }
        return this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
    }

    protected void registerProcessorActions(Processor processor) {
        this.register(processor);
    }

    protected void register(Processor processor) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.configuration.getModelInfo() instanceof WSDLModelInfo) {
            bl2 = true;
            bl = true;
            bl3 = true;
        }
        if (bl) {
            processor.add(this.getAction("service.generator"));
        }
        if (bl3) {
            processor.add(this.getAction("jaxb.type.generator"));
        }
        if (bl2) {
            processor.add(this.getAction("custom.exception.generator"));
            processor.add(this.getAction("remote.interface.impl.generator"));
        }
    }

    protected Configuration createConfiguration() throws Exception {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        Reader reader = new Reader(this.environment, this.properties);
        return reader.parse(this.entityResolver, this.inputFiles);
    }

    protected void beforeHook() {
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        this.properties.setProperty("sourceDirectory", this.sourceDir.getAbsolutePath());
        this.properties.setProperty("destinationDirectory", this.destDir.getAbsolutePath());
        this.properties.setProperty("nonclassDestinationDirectory", this.nonclassDestDir.getAbsolutePath());
        this.properties.setProperty("extension", this.extensions ? "true" : "false");
        this.properties.setProperty("printStackTrace", this.verbose ? "true" : "false");
        this.properties.setProperty("protocol", this.protocol);
        this.properties.setProperty("transport", this.transport);
        this.properties.setProperty("sourceVersion", this.getSourceVersion());
        if (this.wsdlLocation != null) {
            this.properties.setProperty("wsdllocation", this.wsdlLocation);
        }
        if (this.defaultPackage != null) {
            this.properties.setProperty("defaultpackage", this.defaultPackage);
        }
        this.properties.setProperty("doNotOverWrite", this.doNotOverWrite ? "true" : "false");
    }

    @Override
    protected String getGenericErrorMessage() {
        return "wscompile.error";
    }

    @Override
    protected String getResourceBundleName() {
        return "com.sun.tools.internal.ws.resources.wscompile";
    }

    @Override
    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    @Override
    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    @Override
    public void onError(Localizable localizable) {
        this.report(this.getMessage("wscompile.error", this.localizer.localize(localizable)));
    }

    @Override
    public void onWarning(Localizable localizable) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(localizable)));
    }

    @Override
    public void onInfo(Localizable localizable) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(localizable)));
    }

    @Override
    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        if (this.verbose) {
            annotationProcessorEnvironment.getMessager().printNotice("\tap round: " + ++this.round);
        }
        this.webServiceAP.init(annotationProcessorEnvironment);
        return this.webServiceAP;
    }

    private Class getClass(String string) {
        try {
            ProcessorEnvironment processorEnvironment = this.createEnvironment();
            return processorEnvironment.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private ProcessorEnvironment createEnvironment() throws Exception {
        String string = this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
        ClientProcessorEnvironment clientProcessorEnvironment = new ClientProcessorEnvironment(System.out, string, this.listener);
        return clientProcessorEnvironment;
    }

    protected void usage() {
        this.help();
    }

    protected void help() {
        this.report(this.getMessage(this.program + ".help", this.program));
        this.report(this.getMessage(this.program + ".usage.examples"));
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("*");
        hashSet.add("javax.jws.*");
        hashSet.add("javax.jws.soap.*");
        supportedAnnotations = Collections.unmodifiableCollection(hashSet);
    }
}

