/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import sun.swing.text.html.FrameEditorPaneTag;

class FrameView
extends ComponentView
implements HyperlinkListener {
    JEditorPane htmlPane;
    JScrollPane scroller;
    boolean editable;
    float width;
    float height;
    URL src;
    private boolean createdComponent;

    public FrameView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        if (string != null && !string.equals("")) {
            try {
                Object object;
                Object object2;
                URL uRL = ((HTMLDocument)element.getDocument()).getBase();
                this.src = new URL(uRL, string);
                this.htmlPane = new FrameEditorPane();
                this.htmlPane.addHyperlinkListener(this);
                JEditorPane jEditorPane = this.getHostPane();
                boolean bl = true;
                if (jEditorPane != null) {
                    this.htmlPane.setEditable(jEditorPane.isEditable());
                    object2 = (String)jEditorPane.getClientProperty("charset");
                    if (object2 != null) {
                        this.htmlPane.putClientProperty("charset", object2);
                    }
                    if ((object = (HTMLEditorKit)jEditorPane.getEditorKit()) != null) {
                        bl = ((HTMLEditorKit)object).isAutoFormSubmission();
                    }
                }
                this.htmlPane.setPage(this.src);
                object2 = (HTMLEditorKit)this.htmlPane.getEditorKit();
                if (object2 != null) {
                    ((HTMLEditorKit)object2).setAutoFormSubmission(bl);
                }
                if ((object = this.htmlPane.getDocument()) instanceof HTMLDocument) {
                    ((HTMLDocument)object).setFrameDocumentState(true);
                }
                this.setMargin();
                this.createScrollPane();
                this.setBorder();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.createdComponent = true;
        return this.scroller;
    }

    JEditorPane getHostPane() {
        Container container;
        for (container = this.getContainer(); container != null && !(container instanceof JEditorPane); container = container.getParent()) {
        }
        return (JEditorPane)container;
    }

    public void setParent(View view) {
        if (view != null) {
            JTextComponent jTextComponent = (JTextComponent)view.getContainer();
            this.editable = jTextComponent.isEditable();
        }
        super.setParent(view);
    }

    public void paint(Graphics graphics, Shape shape) {
        Container container = this.getContainer();
        if (container != null && this.htmlPane != null && this.htmlPane.isEditable() != ((JTextComponent)container).isEditable()) {
            this.editable = ((JTextComponent)container).isEditable();
            this.htmlPane.setEditable(this.editable);
        }
        super.paint(graphics, shape);
    }

    private void setMargin() {
        int n = 0;
        Insets insets = this.htmlPane.getMargin();
        boolean bl = false;
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINWIDTH);
        Insets insets2 = insets != null ? new Insets(insets.top, insets.left, insets.right, insets.bottom) : new Insets(0, 0, 0, 0);
        if (string != null && (n = Integer.parseInt(string)) > 0) {
            insets2.left = n;
            insets2.right = n;
            bl = true;
        }
        if ((string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINHEIGHT)) != null && (n = Integer.parseInt(string)) > 0) {
            insets2.top = n;
            insets2.bottom = n;
            bl = true;
        }
        if (bl) {
            this.htmlPane.setMargin(insets2);
        }
    }

    private void setBorder() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.FRAMEBORDER);
        if (string != null && (string.equals("no") || string.equals("0"))) {
            this.scroller.setBorder(null);
        }
    }

    private void createScrollPane() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SCROLLING);
        if (string == null) {
            string = "auto";
        }
        this.scroller = !string.equals("no") ? (string.equals("yes") ? new JScrollPane(22, 32) : new JScrollPane()) : new JScrollPane(21, 31);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.add(this.htmlPane);
        jViewport.setBackingStoreEnabled(true);
        this.scroller.setMinimumSize(new Dimension(5, 5));
        this.scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    JEditorPane getOutermostJEditorPane() {
        View view = null;
        for (View view2 = this.getParent(); view2 != null; view2 = view2.getParent()) {
            if (!(view2 instanceof FrameSetView)) continue;
            view = (FrameSetView)view2;
        }
        if (view != null) {
            return (JEditorPane)view.getContainer();
        }
        return null;
    }

    private boolean inNestedFrameSet() {
        FrameSetView frameSetView = (FrameSetView)this.getParent();
        return frameSetView.getParent() instanceof FrameSetView;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        JEditorPane jEditorPane = this.getOutermostJEditorPane();
        if (jEditorPane == null) {
            return;
        }
        if (!(hyperlinkEvent instanceof HTMLFrameHyperlinkEvent)) {
            jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            return;
        }
        HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
        if (hTMLFrameHyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string;
            String string2 = string = hTMLFrameHyperlinkEvent.getTarget();
            if (string.equals("_parent") && !this.inNestedFrameSet()) {
                string = "_top";
            }
            if (hyperlinkEvent instanceof FormSubmitEvent) {
                HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
                if (hTMLEditorKit != null && hTMLEditorKit.isAutoFormSubmission()) {
                    if (string.equals("_top")) {
                        try {
                            this.movePostData(jEditorPane, string2);
                            jEditorPane.setPage(hTMLFrameHyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {}
                    } else {
                        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                        hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                    }
                } else {
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
                return;
            }
            if (string.equals("_top")) {
                try {
                    jEditorPane.setPage(hTMLFrameHyperlinkEvent.getURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!jEditorPane.isEditable()) {
                jEditorPane.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(jEditorPane, hTMLFrameHyperlinkEvent.getEventType(), hTMLFrameHyperlinkEvent.getURL(), hTMLFrameHyperlinkEvent.getDescription(), this.getElement(), hTMLFrameHyperlinkEvent.getInputEvent(), string));
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        URL uRL = this.src;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        URL uRL2 = ((HTMLDocument)element.getDocument()).getBase();
        try {
            if (!this.createdComponent) {
                return;
            }
            Object object = this.movePostData(this.htmlPane, null);
            this.src = new URL(uRL2, string);
            if (uRL.equals(this.src) && this.src.getRef() == null && object == null) {
                return;
            }
            this.htmlPane.setPage(this.src);
            Document document = this.htmlPane.getDocument();
            if (document instanceof HTMLDocument) {
                ((HTMLDocument)document).setFrameDocumentState(true);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object movePostData(JEditorPane jEditorPane, String string) {
        Object object = null;
        JEditorPane jEditorPane2 = this.getOutermostJEditorPane();
        if (jEditorPane2 != null) {
            if (string == null) {
                string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
            }
            if (string != null) {
                String string2 = "javax.swing.JEditorPane.postdata." + string;
                Document document = jEditorPane2.getDocument();
                object = document.getProperty(string2);
                if (object != null) {
                    jEditorPane.getDocument().putProperty("javax.swing.JEditorPane.postdata", object);
                    document.putProperty(string2, null);
                }
            }
        }
        return object;
    }

    public float getMinimumSpan(int n) {
        return 5.0f;
    }

    public float getMaximumSpan(int n) {
        return 2.1474836E9f;
    }

    class FrameEditorPane
    extends JEditorPane
    implements FrameEditorPaneTag {
        FrameEditorPane() {
        }

        public EditorKit getEditorKitForContentType(String string) {
            EditorKit editorKit = super.getEditorKitForContentType(string);
            JEditorPane jEditorPane = null;
            jEditorPane = FrameView.this.getOutermostJEditorPane();
            if (jEditorPane != null) {
                EditorKit editorKit2 = jEditorPane.getEditorKitForContentType(string);
                if (!editorKit.getClass().equals(editorKit2.getClass())) {
                    editorKit = (EditorKit)editorKit2.clone();
                    this.setEditorKitForContentType(string, editorKit);
                }
            }
            return editorKit;
        }

        FrameView getFrameView() {
            return FrameView.this;
        }
    }
}

