/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import bsh.EvalError;
import bsh.Interpreter;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class EvaluateBeanshell
extends AbstractNonCacheableEnforcerRule {
    private static final Interpreter bsh = new Interpreter();
    public String condition;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            log.debug((CharSequence)("Echo condition : " + this.condition));
            String script = (String)helper.evaluate(this.condition);
            log.debug((CharSequence)("Echo script : " + script));
            if (!this.evaluateCondition(script, log)) {
                if (StringUtils.isEmpty((String)this.message)) {
                    this.message = "The expression \"" + this.condition + "\" is not true.";
                }
                throw new EnforcerRuleException(this.message);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to evaluate an expression '" + this.condition + "'", (Exception)((Object)e));
        }
    }

    protected boolean evaluateCondition(String script, Log log) throws EnforcerRuleException {
        Boolean evaluation = Boolean.FALSE;
        try {
            evaluation = (Boolean)bsh.eval(script);
            log.debug((CharSequence)("Echo evaluating : " + evaluation));
        }
        catch (EvalError ex) {
            throw new EnforcerRuleException("Couldn't evaluate condition: " + script, (Exception)((Object)ex));
        }
        return evaluation;
    }
}

