/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.Tool;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class Interp {
    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("java Interp file.g tokens-to-ignore start-rule input-file");
            return;
        }
        String grammarFileName = args[0];
        String ignoreTokens = args[1];
        String startRule = args[2];
        String inputFileName = args[3];
        Tool tool = new Tool();
        CompositeGrammar composite = new CompositeGrammar();
        Grammar parser = new Grammar(tool, grammarFileName, composite);
        composite.setDelegationRoot(parser);
        FileReader fr = new FileReader(grammarFileName);
        BufferedReader br = new BufferedReader(fr);
        parser.parseAndBuildAST(br);
        br.close();
        parser.composite.assignTokenTypes();
        parser.composite.defineGrammarSymbols();
        parser.composite.createNFAs();
        List leftRecursiveRules = parser.checkAllRulesForLeftRecursion();
        if (leftRecursiveRules.size() > 0) {
            return;
        }
        if (parser.getRule(startRule) == null) {
            System.out.println("undefined start rule " + startRule);
            return;
        }
        String lexerGrammarText = parser.getLexerGrammar();
        Grammar lexer = new Grammar();
        lexer.importTokenVocabulary(parser);
        lexer.fileName = grammarFileName;
        lexer.setTool(tool);
        if (lexerGrammarText != null) {
            lexer.setGrammarContent(lexerGrammarText);
        } else {
            System.err.println("no lexer grammar found in " + grammarFileName);
        }
        lexer.composite.createNFAs();
        ANTLRFileStream input = new ANTLRFileStream(inputFileName);
        Interpreter lexEngine = new Interpreter(lexer, (IntStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexEngine);
        StringTokenizer tk = new StringTokenizer(ignoreTokens, " ");
        while (tk.hasMoreTokens()) {
            String tokenName = tk.nextToken();
            tokens.setTokenTypeChannel(lexer.getTokenType(tokenName), 99);
        }
        if (parser.getRule(startRule) == null) {
            System.err.println("Rule " + startRule + " does not exist in " + grammarFileName);
            return;
        }
        Interpreter parseEngine = new Interpreter(parser, (IntStream)tokens);
        ParseTree t = parseEngine.parse(startRule);
        System.out.println(t.toStringTree());
    }
}

