/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.regex.Pattern;

public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    private Pattern mForbiddenSummaryFragments = Utils.createPattern("^$");

    public void setForbiddenSummaryFragments(String aPattern) {
        this.mForbiddenSummaryFragments = Utils.createPattern(aPattern);
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode aAst) {
        String firstSentence = this.getFirstSentence(aAst);
        int endOfSentence = firstSentence.lastIndexOf(".");
        if (endOfSentence == -1) {
            this.log(aAst.getLineNumber(), "summary.first.sentence", new Object[0]);
        } else if (this.containsForbiddenFragment(firstSentence = firstSentence.substring(0, endOfSentence))) {
            this.log(aAst.getLineNumber(), "summary.javaDoc", new Object[0]);
        }
    }

    private String getFirstSentence(DetailNode aAst) {
        StringBuilder result = new StringBuilder();
        for (DetailNode child : aAst.getChildren()) {
            if (child.getType() != 10072 && child.getText().contains(". ")) {
                result.append(this.getCharsTillDot(child));
                break;
            }
            result.append(child.getText());
        }
        return result.toString();
    }

    private String getCharsTillDot(DetailNode aTextNode) {
        StringBuilder result = new StringBuilder();
        for (DetailNode child : aTextNode.getChildren()) {
            result.append(child.getText());
            if (".".equals(child.getText()) && JavadocUtils.getNextSibling(child).getType() == 4) break;
        }
        return result.toString();
    }

    private boolean containsForbiddenFragment(String aFirstSentence) {
        String javadocText = aFirstSentence.replaceAll("\n[ ]+(\\*)|^[ ]+(\\*)", " ");
        javadocText = CharMatcher.WHITESPACE.trimAndCollapseFrom((CharSequence)javadocText, ' ');
        return this.mForbiddenSummaryFragments.matcher(javadocText).find();
    }
}

