/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc;

import com.sun.tools.internal.jxc.Messages;
import com.sun.tools.internal.jxc.gen.config.NGCCRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NGCCRuntimeEx
extends NGCCRuntime {
    private final ErrorHandler errorHandler;

    public NGCCRuntimeEx(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public File getBaseDir(String string) throws SAXException {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        SAXParseException sAXParseException = new SAXParseException(Messages.BASEDIR_DOESNT_EXIST.format(file.getAbsolutePath()), this.getLocator());
        this.errorHandler.error(sAXParseException);
        throw sAXParseException;
    }

    public List<Pattern> getIncludePatterns(List list) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String string2 = this.convertToRegex(string);
            Pattern pattern = Pattern.compile(string2);
            arrayList.add(pattern);
        }
        return arrayList;
    }

    public List getExcludePatterns(List list) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String string2 = this.convertToRegex(string);
            Pattern pattern = Pattern.compile(string2);
            arrayList.add(pattern);
        }
        return arrayList;
    }

    private String convertToRegex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 32;
        if (string.length() > 0) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n2 = i;
                n = 32;
                if (n2 + 1 != string.length()) {
                    n = string.charAt(n2 + 1);
                }
                if (c == '.' && n != 46) {
                    stringBuilder.append('\\');
                    stringBuilder.append('.');
                    continue;
                }
                if (c == '.' && n == 46) continue;
                if (c == '*' && n == 42) {
                    stringBuilder.append(".*");
                    break;
                }
                if (c == '*') {
                    stringBuilder.append("[^\\.]+");
                    continue;
                }
                if (c == '?') {
                    stringBuilder.append("[^\\.]");
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected void unexpectedX(String string) throws SAXException {
        this.errorHandler.error(new SAXParseException(Messages.UNEXPECTED_NGCC_TOKEN.format(string, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()), this.getLocator()));
    }
}

