/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.gbind;

import com.sun.tools.internal.xjc.reader.gbind.ElementSet;
import com.sun.tools.internal.xjc.reader.gbind.ElementSets;
import com.sun.tools.internal.xjc.reader.gbind.Expression;

public final class Sequence
extends Expression {
    private final Expression lhs;
    private final Expression rhs;
    private final boolean isNullable;
    private ElementSet lastSet;

    public Sequence(Expression expression, Expression expression2) {
        this.lhs = expression;
        this.rhs = expression2;
        this.isNullable = expression.isNullable() && expression2.isNullable();
    }

    ElementSet lastSet() {
        if (this.lastSet == null) {
            this.lastSet = this.rhs.isNullable() ? ElementSets.union(this.lhs.lastSet(), this.rhs.lastSet()) : this.rhs.lastSet();
        }
        return this.lastSet;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void buildDAG(ElementSet elementSet) {
        this.lhs.buildDAG(elementSet);
        if (this.lhs.isNullable()) {
            this.rhs.buildDAG(ElementSets.union(elementSet, this.lhs.lastSet()));
        } else {
            this.rhs.buildDAG(this.lhs.lastSet());
        }
    }

    public String toString() {
        return '(' + this.lhs.toString() + ',' + this.rhs.toString() + ')';
    }
}

