/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema.parser;

import com.sun.tools.internal.xjc.ConsoleErrorReporter;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.LSInputSAXWrapper;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.Messages;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaConstraintChecker {
    public static boolean check(InputSource[] inputSourceArray, ErrorReceiver errorReceiver, final EntityResolver entityResolver) {
        ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(errorReceiver);
        boolean bl = false;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(errorReceiverFilter);
        if (entityResolver != null) {
            schemaFactory.setResourceResolver(new LSResourceResolver(){

                public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
                    try {
                        InputSource inputSource = entityResolver.resolveEntity(string2, string4);
                        if (inputSource == null) {
                            return null;
                        }
                        return new LSInputSAXWrapper(inputSource);
                    }
                    catch (SAXException sAXException) {
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
        }
        try {
            schemaFactory.newSchema(SchemaConstraintChecker.getSchemaSource(inputSourceArray));
        }
        catch (SAXException sAXException) {
            bl = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            errorReceiver.warning(null, Messages.format("SchemaConstraintChecker.UnableToCheckCorrectness", new Object[0]));
        }
        return !bl && !errorReceiverFilter.hadError();
    }

    private static Source[] getSchemaSource(InputSource[] inputSourceArray) {
        Source[] sourceArray = new SAXSource[inputSourceArray.length];
        for (int i = 0; i < inputSourceArray.length; ++i) {
            sourceArray[i] = new SAXSource(inputSourceArray[i]);
        }
        return sourceArray;
    }

    public static void main(String[] stringArray) throws IOException {
        InputSource[] inputSourceArray = new InputSource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            inputSourceArray[i] = new InputSource(new File(stringArray[i]).toURL().toExternalForm());
        }
        SchemaConstraintChecker.check(inputSourceArray, new ConsoleErrorReporter(), null);
    }
}

