/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacMessages
implements Messages {
    protected static final Context.Key<JavacMessages> messagesKey = new Context.Key();
    private Map<Locale, SoftReference<List<ResourceBundle>>> bundleCache;
    private List<String> bundleNames = List.nil();
    private Locale currentLocale;
    private List<ResourceBundle> currentBundles;
    private static final String defaultBundleName = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle defaultBundle;
    private static JavacMessages defaultMessages;

    public static JavacMessages instance(Context context) {
        JavacMessages javacMessages = context.get(messagesKey);
        if (javacMessages == null) {
            javacMessages = new JavacMessages(context);
        }
        return javacMessages;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.currentBundles = this.getBundles(locale);
        this.currentLocale = locale;
    }

    public JavacMessages(Context context) {
        this(defaultBundleName);
        context.put(messagesKey, this);
    }

    public JavacMessages(String string) throws MissingResourceException {
        this.bundleCache = new HashMap<Locale, SoftReference<List<ResourceBundle>>>();
        this.add(string);
        this.setCurrentLocale(Locale.getDefault());
    }

    public JavacMessages() throws MissingResourceException {
        this(defaultBundleName);
    }

    @Override
    public void add(String string) throws MissingResourceException {
        this.bundleNames = this.bundleNames.prepend(string);
        if (!this.bundleCache.isEmpty()) {
            this.bundleCache.clear();
        }
        this.currentBundles = null;
    }

    public List<ResourceBundle> getBundles(Locale locale) {
        List<ResourceBundle> list;
        if (locale == this.currentLocale && this.currentBundles != null) {
            return this.currentBundles;
        }
        SoftReference<List<ResourceBundle>> softReference = this.bundleCache.get(locale);
        List<ResourceBundle> list2 = list = softReference == null ? null : softReference.get();
        if (list == null) {
            list = List.nil();
            for (String string : this.bundleNames) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                    list = list.prepend(resourceBundle);
                }
                catch (MissingResourceException missingResourceException) {
                    throw new InternalError("Cannot find javac resource bundle for locale " + locale);
                }
            }
            this.bundleCache.put(locale, new SoftReference<List<ResourceBundle>>(list));
        }
        return list;
    }

    public String getLocalizedString(String string, Object ... objectArray) {
        return this.getLocalizedString(this.currentLocale, string, objectArray);
    }

    @Override
    public String getLocalizedString(Locale locale, String string, Object ... objectArray) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        return JavacMessages.getLocalizedString(this.getBundles(locale), string, objectArray);
    }

    static String getDefaultLocalizedString(String string, Object ... objectArray) {
        return JavacMessages.getLocalizedString(List.of(JavacMessages.getDefaultBundle()), string, objectArray);
    }

    @Deprecated
    static JavacMessages getDefaultMessages() {
        if (defaultMessages == null) {
            defaultMessages = new JavacMessages(defaultBundleName);
        }
        return defaultMessages;
    }

    public static ResourceBundle getDefaultBundle() {
        try {
            if (defaultBundle == null) {
                defaultBundle = ResourceBundle.getBundle(defaultBundleName);
            }
            return defaultBundle;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing", missingResourceException);
        }
    }

    private static String getLocalizedString(List<ResourceBundle> list, String string, Object ... objectArray) {
        String string2 = null;
        List<ResourceBundle> list2 = list;
        while (list2.nonEmpty() && string2 == null) {
            ResourceBundle resourceBundle = (ResourceBundle)list2.head;
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            list2 = list2.tail;
        }
        if (string2 == null) {
            string2 = "compiler message file broken: key=" + string + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        return MessageFormat.format(string2, objectArray);
    }
}

