/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import java.text.BreakIterator;
import java.text.Collator;
import java.util.Locale;

class DocLocale {
    final String localeName;
    final Locale locale;
    final Collator collator;
    private final DocEnv docenv;
    private final BreakIterator sentenceBreaker;
    private boolean useBreakIterator = false;
    static final String[] sentenceTerminators = new String[]{"<p>", "</p>", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>", "</h1>", "</h2>", "</h3>", "</h4>", "</h5>", "</h6>", "<hr>", "<pre>", "</pre>"};

    DocLocale(DocEnv docEnv, String string, boolean bl) {
        this.docenv = docEnv;
        this.localeName = string;
        this.useBreakIterator = bl;
        this.locale = this.getLocale();
        if (this.locale == null) {
            docEnv.exit();
        } else {
            Locale.setDefault(this.locale);
        }
        this.collator = Collator.getInstance(this.locale);
        this.sentenceBreaker = BreakIterator.getSentenceInstance(this.locale);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Locale getLocale() {
        Locale locale = null;
        if (this.localeName.length() <= 0) return Locale.getDefault();
        int n = this.localeName.indexOf(95);
        int n2 = -1;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (n == 2) {
            string = this.localeName.substring(0, n);
            n2 = this.localeName.indexOf(95, n + 1);
            if (n2 > 0) {
                if (n2 != n + 3 || this.localeName.length() <= n2 + 1) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                string2 = this.localeName.substring(n + 1, n2);
                string3 = this.localeName.substring(n2 + 1);
            } else {
                if (this.localeName.length() != n + 3) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                string2 = this.localeName.substring(n + 1);
            }
        } else if (n == -1 && this.localeName.length() == 2) {
            string = this.localeName;
        } else {
            this.docenv.error(null, "main.malformed_locale_name", this.localeName);
            return null;
        }
        locale = this.searchLocale(string, string2, string3);
        if (locale == null) {
            this.docenv.error(null, "main.illegal_locale_name", this.localeName);
            return null;
        }
        return locale;
    }

    private Locale searchLocale(String string, String string2, String string3) {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!localeArray[i].getLanguage().equals(string) || string2 != null && !localeArray[i].getCountry().equals(string2) || string3 != null && !localeArray[i].getVariant().equals(string3)) continue;
            return localeArray[i];
        }
        return null;
    }

    String localeSpecificFirstSentence(DocImpl docImpl, String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.indexOf("-->");
        if (string.trim().startsWith("<!--") && n != -1) {
            return this.localeSpecificFirstSentence(docImpl, string.substring(n + 3, string.length()));
        }
        if (this.useBreakIterator || !this.locale.getLanguage().equals("en")) {
            this.sentenceBreaker.setText(string.replace('\n', ' '));
            int n2 = this.sentenceBreaker.first();
            int n3 = this.sentenceBreaker.next();
            return string.substring(n2, n3).trim();
        }
        return this.englishLanguageFirstSentence(string).trim();
    }

    private String englishLanguageFirstSentence(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        boolean bl = false;
        block5: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '.': {
                    bl = true;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) continue block5;
                    return string.substring(0, i);
                }
                case '<': {
                    if (i <= 0 || !this.htmlSentenceTerminatorFound(string, i)) continue block5;
                    return string.substring(0, i);
                }
                default: {
                    bl = false;
                }
            }
        }
        return string;
    }

    private boolean htmlSentenceTerminatorFound(String string, int n) {
        for (int i = 0; i < sentenceTerminators.length; ++i) {
            String string2 = sentenceTerminators[i];
            if (!string.regionMatches(true, n, string2, 0, string2.length())) continue;
            return true;
        }
        return false;
    }
}

