/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import java.util.ArrayList;
import java.util.Collection;
import org.xml.sax.SAXException;

public abstract class BinaryPattern
extends Pattern {
    protected final Pattern p1;
    protected final Pattern p2;

    BinaryPattern(boolean bl, int n, Pattern pattern, Pattern pattern2) {
        super(bl, Math.max(pattern.getContentType(), pattern2.getContentType()), n);
        this.p1 = pattern;
        this.p2 = pattern2;
    }

    void checkRecursion(int n) throws SAXException {
        this.p1.checkRecursion(n);
        this.p2.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet);
    }

    boolean samePattern(Pattern pattern) {
        if (this.getClass() != pattern.getClass()) {
            return false;
        }
        BinaryPattern binaryPattern = (BinaryPattern)pattern;
        return this.p1 == binaryPattern.p1 && this.p2 == binaryPattern.p2;
    }

    public final Pattern getOperand1() {
        return this.p1;
    }

    public final Pattern getOperand2() {
        return this.p2;
    }

    public final void fillChildren(Collection collection) {
        this.fillChildren(this.getClass(), this.p1, collection);
        this.fillChildren(this.getClass(), this.p2, collection);
    }

    public final Pattern[] getChildren() {
        ArrayList arrayList = new ArrayList();
        this.fillChildren(arrayList);
        return arrayList.toArray(new Pattern[arrayList.size()]);
    }

    private void fillChildren(Class clazz, Pattern pattern, Collection collection) {
        if (pattern.getClass() == clazz) {
            BinaryPattern binaryPattern = (BinaryPattern)pattern;
            binaryPattern.fillChildren(clazz, binaryPattern.p1, collection);
            binaryPattern.fillChildren(clazz, binaryPattern.p2, collection);
        } else {
            collection.add(pattern);
        }
    }
}

