/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import com.sun.xml.internal.rngom.binary.SchemaPatternBuilder;
import com.sun.xml.internal.rngom.binary.visitor.PatternFunction;
import com.sun.xml.internal.rngom.binary.visitor.PatternVisitor;
import org.xml.sax.SAXException;

public class OneOrMorePattern
extends Pattern {
    Pattern p;

    OneOrMorePattern(Pattern pattern) {
        super(pattern.isNullable(), pattern.getContentType(), OneOrMorePattern.combineHashCode(19, pattern.hashCode()));
        this.p = pattern;
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeOneOrMore(pattern);
        }
        return this;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(n == 1 ? 2 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !OneOrMorePattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }

    boolean samePattern(Pattern pattern) {
        return pattern instanceof OneOrMorePattern && this.p == ((OneOrMorePattern)pattern).p;
    }

    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitOneOrMore(this.p);
    }

    public Object apply(PatternFunction patternFunction) {
        return patternFunction.caseOneOrMore(this);
    }

    Pattern getOperand() {
        return this.p;
    }
}

