/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.parse.compact;

import com.sun.xml.internal.rngom.ast.builder.BuildException;
import com.sun.xml.internal.rngom.ast.builder.IncludedGrammar;
import com.sun.xml.internal.rngom.ast.builder.SchemaBuilder;
import com.sun.xml.internal.rngom.ast.builder.Scope;
import com.sun.xml.internal.rngom.ast.om.ParsedPattern;
import com.sun.xml.internal.rngom.parse.IllegalSchemaException;
import com.sun.xml.internal.rngom.parse.Parseable;
import com.sun.xml.internal.rngom.parse.compact.CompactSyntax;
import com.sun.xml.internal.rngom.xml.util.EncodingMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class CompactParseable
implements Parseable {
    private final InputSource in;
    private final ErrorHandler eh;
    private static final String UTF8 = EncodingMap.getJavaName("UTF-8");
    private static final String UTF16 = EncodingMap.getJavaName("UTF-16");

    public CompactParseable(InputSource inputSource, ErrorHandler errorHandler) {
        this.in = inputSource;
        this.eh = errorHandler;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder) throws BuildException, IllegalSchemaException {
        ParsedPattern parsedPattern = new CompactSyntax(this, CompactParseable.makeReader(this.in), this.in.getSystemId(), schemaBuilder, this.eh, "").parse(null);
        return schemaBuilder.expandPattern(parsedPattern);
    }

    public ParsedPattern parseInclude(String string, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar, String string2) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(this, CompactParseable.makeReader(inputSource), string, schemaBuilder, this.eh, string2).parseInclude(includedGrammar);
    }

    public ParsedPattern parseExternal(String string, SchemaBuilder schemaBuilder, Scope scope, String string2) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(this, CompactParseable.makeReader(inputSource), string, schemaBuilder, this.eh, string2).parse(scope);
    }

    private static Reader makeReader(InputSource inputSource) throws BuildException {
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                String string;
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream == null) {
                    string = inputSource.getSystemId();
                    inputStream = new URL(string).openStream();
                }
                if ((string = inputSource.getEncoding()) == null) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    string = CompactParseable.detectEncoding(pushbackInputStream);
                    inputStream = pushbackInputStream;
                }
                reader = new InputStreamReader(inputStream, string);
            }
            return reader;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static String detectEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        String string = UTF8;
        int n = pushbackInputStream.read();
        if (n != -1) {
            int n2 = pushbackInputStream.read();
            if (n2 != -1) {
                pushbackInputStream.unread(n2);
                if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
                    string = UTF16;
                }
            }
            pushbackInputStream.unread(n);
        }
        return string;
    }
}

