/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.util;

import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSAttGroupDecl;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSAttributeUse;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSContentType;
import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSIdentityConstraint;
import com.sun.xml.internal.xsom.XSListSimpleType;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSNotation;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSRestrictionSimpleType;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.XSUnionSimpleType;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.XSXPath;
import com.sun.xml.internal.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.internal.xsom.visitor.XSTermVisitor;
import com.sun.xml.internal.xsom.visitor.XSVisitor;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;

public class SchemaWriter
implements XSVisitor,
XSSimpleTypeVisitor {
    private final Writer out;
    private int indent;
    private boolean hadError = false;

    public SchemaWriter(Writer writer) {
        this.out = writer;
    }

    private void println(String string) {
        try {
            for (int i = 0; i < this.indent; ++i) {
                this.out.write("  ");
            }
            this.out.write(string);
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException iOException) {
            this.hadError = true;
        }
    }

    private void println() {
        this.println("");
    }

    public boolean checkError() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.hadError = true;
        }
        return this.hadError;
    }

    public void visit(XSSchemaSet xSSchemaSet) {
        Iterator<XSSchema> iterator = xSSchemaSet.iterateSchema();
        while (iterator.hasNext()) {
            this.schema(iterator.next());
            this.println();
        }
    }

    public void schema(XSSchema xSSchema) {
        if (xSSchema.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        this.println(MessageFormat.format("<schema targetNamespace=\"{0}\">", xSSchema.getTargetNamespace()));
        ++this.indent;
        Iterator<XSDeclaration> iterator = xSSchema.iterateAttGroupDecls();
        while (iterator.hasNext()) {
            this.attGroupDecl(iterator.next());
        }
        iterator = xSSchema.iterateAttributeDecls();
        while (iterator.hasNext()) {
            this.attributeDecl((XSAttributeDecl)iterator.next());
        }
        iterator = xSSchema.iterateComplexTypes();
        while (iterator.hasNext()) {
            this.complexType((XSComplexType)iterator.next());
        }
        iterator = xSSchema.iterateElementDecls();
        while (iterator.hasNext()) {
            this.elementDecl((XSElementDecl)iterator.next());
        }
        iterator = xSSchema.iterateModelGroupDecls();
        while (iterator.hasNext()) {
            this.modelGroupDecl((XSModelGroupDecl)iterator.next());
        }
        iterator = xSSchema.iterateSimpleTypes();
        while (iterator.hasNext()) {
            this.simpleType((XSSimpleType)iterator.next());
        }
        --this.indent;
        this.println("</schema>");
    }

    public void attGroupDecl(XSAttGroupDecl xSAttGroupDecl) {
        this.println(MessageFormat.format("<attGroup name=\"{0}\">", xSAttGroupDecl.getName()));
        ++this.indent;
        Iterator<XSComponent> iterator = xSAttGroupDecl.iterateAttGroups();
        while (iterator.hasNext()) {
            this.dumpRef(iterator.next());
        }
        iterator = xSAttGroupDecl.iterateDeclaredAttributeUses();
        while (iterator.hasNext()) {
            this.attributeUse((XSAttributeUse)iterator.next());
        }
        --this.indent;
        this.println("</attGroup>");
    }

    public void dumpRef(XSAttGroupDecl xSAttGroupDecl) {
        this.println(MessageFormat.format("<attGroup ref=\"'{'{0}'}'{1}\"/>", xSAttGroupDecl.getTargetNamespace(), xSAttGroupDecl.getName()));
    }

    public void attributeUse(XSAttributeUse xSAttributeUse) {
        XSAttributeDecl xSAttributeDecl = xSAttributeUse.getDecl();
        String string = "";
        if (xSAttributeUse.isRequired()) {
            string = string + " use=\"required\"";
        }
        if (xSAttributeUse.getFixedValue() != null && xSAttributeUse.getDecl().getFixedValue() == null) {
            string = string + " fixed=\"" + xSAttributeUse.getFixedValue() + '\"';
        }
        if (xSAttributeUse.getDefaultValue() != null && xSAttributeUse.getDecl().getDefaultValue() == null) {
            string = string + " default=\"" + xSAttributeUse.getDefaultValue() + '\"';
        }
        if (xSAttributeDecl.isLocal()) {
            this.dump(xSAttributeDecl, string);
        } else {
            this.println(MessageFormat.format("<attribute ref=\"'{'{0}'}'{1}{2}\"/>", xSAttributeDecl.getTargetNamespace(), xSAttributeDecl.getName(), string));
        }
    }

    public void attributeDecl(XSAttributeDecl xSAttributeDecl) {
        this.dump(xSAttributeDecl, "");
    }

    private void dump(XSAttributeDecl xSAttributeDecl, String string) {
        XSSimpleType xSSimpleType = xSAttributeDecl.getType();
        this.println(MessageFormat.format("<attribute name=\"{0}\"{1}{2}{3}{4}{5}>", xSAttributeDecl.getName(), string, xSSimpleType.isLocal() ? "" : MessageFormat.format(" type=\"'{'{0}'}'{1}\"", xSSimpleType.getTargetNamespace(), xSSimpleType.getName()), xSAttributeDecl.getFixedValue() == null ? "" : " fixed=\"" + xSAttributeDecl.getFixedValue() + '\"', xSAttributeDecl.getDefaultValue() == null ? "" : " default=\"" + xSAttributeDecl.getDefaultValue() + '\"', xSSimpleType.isLocal() ? "" : " /"));
        if (xSSimpleType.isLocal()) {
            ++this.indent;
            this.simpleType(xSSimpleType);
            --this.indent;
            this.println("</attribute>");
        }
    }

    public void simpleType(XSSimpleType xSSimpleType) {
        this.println(MessageFormat.format("<simpleType{0}>", xSSimpleType.isLocal() ? "" : " name=\"" + xSSimpleType.getName() + '\"'));
        ++this.indent;
        xSSimpleType.visit(this);
        --this.indent;
        this.println("</simpleType>");
    }

    public void listSimpleType(XSListSimpleType xSListSimpleType) {
        XSSimpleType xSSimpleType = xSListSimpleType.getItemType();
        if (xSSimpleType.isLocal()) {
            this.println("<list>");
            ++this.indent;
            this.simpleType(xSSimpleType);
            --this.indent;
            this.println("</list>");
        } else {
            this.println(MessageFormat.format("<list itemType=\"'{'{0}'}'{1}\" />", xSSimpleType.getTargetNamespace(), xSSimpleType.getName()));
        }
    }

    public void unionSimpleType(XSUnionSimpleType xSUnionSimpleType) {
        XSSimpleType xSSimpleType;
        int n;
        int n2 = xSUnionSimpleType.getMemberSize();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            xSSimpleType = xSUnionSimpleType.getMember(n);
            if (!xSSimpleType.isGlobal()) continue;
            stringBuffer.append(MessageFormat.format(" '{'{0}'}'{1}", xSSimpleType.getTargetNamespace(), xSSimpleType.getName()));
        }
        if (stringBuffer.length() == 0) {
            this.println("<union>");
        } else {
            this.println("<union memberTypes=\"" + stringBuffer + "\">");
        }
        ++this.indent;
        for (n = 0; n < n2; ++n) {
            xSSimpleType = xSUnionSimpleType.getMember(n);
            if (!xSSimpleType.isLocal()) continue;
            this.simpleType(xSSimpleType);
        }
        --this.indent;
        this.println("</union>");
    }

    public void restrictionSimpleType(XSRestrictionSimpleType xSRestrictionSimpleType) {
        if (xSRestrictionSimpleType.getBaseType() == null) {
            if (!xSRestrictionSimpleType.getName().equals("anySimpleType")) {
                throw new InternalError();
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(xSRestrictionSimpleType.getTargetNamespace())) {
                throw new InternalError();
            }
            return;
        }
        XSSimpleType xSSimpleType = xSRestrictionSimpleType.getSimpleBaseType();
        this.println(MessageFormat.format("<restriction{0}>", xSSimpleType.isLocal() ? "" : " base=\"{" + xSSimpleType.getTargetNamespace() + '}' + xSSimpleType.getName() + '\"'));
        ++this.indent;
        if (xSSimpleType.isLocal()) {
            this.simpleType(xSSimpleType);
        }
        Iterator<XSFacet> iterator = xSRestrictionSimpleType.iterateDeclaredFacets();
        while (iterator.hasNext()) {
            this.facet(iterator.next());
        }
        --this.indent;
        this.println("</restriction>");
    }

    public void facet(XSFacet xSFacet) {
        this.println(MessageFormat.format("<{0} value=\"{1}\"/>", xSFacet.getName(), xSFacet.getValue()));
    }

    public void notation(XSNotation xSNotation) {
        this.println(MessageFormat.format("<notation name='\"0}\" public =\"{1}\" system=\"{2}\" />", xSNotation.getName(), xSNotation.getPublicId(), xSNotation.getSystemId()));
    }

    public void complexType(XSComplexType xSComplexType) {
        this.println(MessageFormat.format("<complexType{0}>", xSComplexType.isLocal() ? "" : " name=\"" + xSComplexType.getName() + '\"'));
        ++this.indent;
        if (xSComplexType.getContentType().asSimpleType() != null) {
            this.println("<simpleContent>");
            ++this.indent;
            XSType xSType = xSComplexType.getBaseType();
            if (xSComplexType.getDerivationMethod() == 2) {
                this.println(MessageFormat.format("<restriction base=\"<{0}>{1}\">", xSType.getTargetNamespace(), xSType.getName()));
                ++this.indent;
                this.dumpComplexTypeAttribute(xSComplexType);
                --this.indent;
                this.println("</restriction>");
            } else {
                this.println(MessageFormat.format("<extension base=\"<{0}>{1}\">", xSType.getTargetNamespace(), xSType.getName()));
                if (xSComplexType.isGlobal() && xSComplexType.getTargetNamespace().equals(xSType.getTargetNamespace()) && xSComplexType.getName().equals(xSType.getName())) {
                    ++this.indent;
                    this.println("<redefine>");
                    ++this.indent;
                    xSType.visit(this);
                    --this.indent;
                    this.println("</redefine>");
                    --this.indent;
                }
                ++this.indent;
                this.dumpComplexTypeAttribute(xSComplexType);
                --this.indent;
                this.println("</extension>");
            }
            --this.indent;
            this.println("</simpleContent>");
        } else {
            this.println("<complexContent>");
            ++this.indent;
            XSComplexType xSComplexType2 = xSComplexType.getBaseType().asComplexType();
            if (xSComplexType.getDerivationMethod() == 2) {
                this.println(MessageFormat.format("<restriction base=\"'{'{0}'}'{1}\">", xSComplexType2.getTargetNamespace(), xSComplexType2.getName()));
                ++this.indent;
                xSComplexType.getContentType().visit(this);
                this.dumpComplexTypeAttribute(xSComplexType);
                --this.indent;
                this.println("</restriction>");
            } else {
                this.println(MessageFormat.format("<extension base=\"'{'{0}'}'{1}\">", xSComplexType2.getTargetNamespace(), xSComplexType2.getName()));
                if (xSComplexType.isGlobal() && xSComplexType.getTargetNamespace().equals(xSComplexType2.getTargetNamespace()) && xSComplexType.getName().equals(xSComplexType2.getName())) {
                    ++this.indent;
                    this.println("<redefine>");
                    ++this.indent;
                    xSComplexType2.visit(this);
                    --this.indent;
                    this.println("</redefine>");
                    --this.indent;
                }
                ++this.indent;
                xSComplexType.getExplicitContent().visit(this);
                this.dumpComplexTypeAttribute(xSComplexType);
                --this.indent;
                this.println("</extension>");
            }
            --this.indent;
            this.println("</complexContent>");
        }
        --this.indent;
        this.println("</complexType>");
    }

    private void dumpComplexTypeAttribute(XSComplexType xSComplexType) {
        Iterator<XSComponent> iterator = xSComplexType.iterateAttGroups();
        while (iterator.hasNext()) {
            this.dumpRef(iterator.next());
        }
        iterator = xSComplexType.iterateDeclaredAttributeUses();
        while (iterator.hasNext()) {
            this.attributeUse((XSAttributeUse)iterator.next());
        }
    }

    public void elementDecl(XSElementDecl xSElementDecl) {
        this.elementDecl(xSElementDecl, "");
    }

    private void elementDecl(XSElementDecl xSElementDecl, String string) {
        XSType xSType = xSElementDecl.getType();
        this.println(MessageFormat.format("<element name=\"{0}\"{1}{2}{3}>", xSElementDecl.getName(), xSType.isLocal() ? "" : " type=\"{" + xSType.getTargetNamespace() + '}' + xSType.getName() + '\"', string, xSType.isLocal() ? "" : "/"));
        if (xSType.isLocal()) {
            ++this.indent;
            if (xSType.isLocal()) {
                xSType.visit(this);
            }
            --this.indent;
            this.println("</element>");
        }
    }

    public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
        this.println(MessageFormat.format("<group name=\"{0}\">", xSModelGroupDecl.getName()));
        ++this.indent;
        this.modelGroup(xSModelGroupDecl.getModelGroup());
        --this.indent;
        this.println("</group>");
    }

    public void modelGroup(XSModelGroup xSModelGroup) {
        this.modelGroup(xSModelGroup, "");
    }

    private void modelGroup(XSModelGroup xSModelGroup, String string) {
        this.println(MessageFormat.format("<{0}{1}>", new Object[]{xSModelGroup.getCompositor(), string}));
        ++this.indent;
        int n = xSModelGroup.getSize();
        for (int i = 0; i < n; ++i) {
            this.particle(xSModelGroup.getChild(i));
        }
        --this.indent;
        this.println(MessageFormat.format("</{0}>", new Object[]{xSModelGroup.getCompositor()}));
    }

    public void particle(XSParticle xSParticle) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = xSParticle.getMaxOccurs();
        if (n == -1) {
            stringBuffer.append(" maxOccurs=\"unbounded\"");
        } else if (n != 1) {
            stringBuffer.append(" maxOccurs=\"" + n + '\"');
        }
        n = xSParticle.getMinOccurs();
        if (n != 1) {
            stringBuffer.append(" minOccurs=\"" + n + '\"');
        }
        final String string = stringBuffer.toString();
        xSParticle.getTerm().visit(new XSTermVisitor(){

            public void elementDecl(XSElementDecl xSElementDecl) {
                if (xSElementDecl.isLocal()) {
                    SchemaWriter.this.elementDecl(xSElementDecl, string);
                } else {
                    SchemaWriter.this.println(MessageFormat.format("<element ref=\"'{'{0}'}'{1}\"{2}/>", xSElementDecl.getTargetNamespace(), xSElementDecl.getName(), string));
                }
            }

            public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
                SchemaWriter.this.println(MessageFormat.format("<group ref=\"'{'{0}'}'{1}\"{2}/>", xSModelGroupDecl.getTargetNamespace(), xSModelGroupDecl.getName(), string));
            }

            public void modelGroup(XSModelGroup xSModelGroup) {
                SchemaWriter.this.modelGroup(xSModelGroup, string);
            }

            public void wildcard(XSWildcard xSWildcard) {
                SchemaWriter.this.wildcard(xSWildcard, string);
            }
        });
    }

    public void wildcard(XSWildcard xSWildcard) {
        this.wildcard(xSWildcard, "");
    }

    private void wildcard(XSWildcard xSWildcard, String string) {
        this.println(MessageFormat.format("<any/>", string));
    }

    public void annotation(XSAnnotation xSAnnotation) {
    }

    public void identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
    }

    public void xpath(XSXPath xSXPath) {
    }

    public void empty(XSContentType xSContentType) {
    }
}

