/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import java.util.Set;

public abstract class Operator {
    private static int nextOrdinal = 0;
    private static HashMap<String, Operator> map = new HashMap();
    private final String name;
    private final int ordinal = nextOrdinal++;
    public static final Operator PLUS = new Operator("+"){

        protected double eval(double d, double d2) {
            return d + d2;
        }
    };
    public static final Operator MINUS = new Operator("-"){

        protected double eval(double d, double d2) {
            return d - d2;
        }
    };
    public static final Operator DIVIDE = new Operator("/"){

        protected double eval(double d, double d2) {
            if (d2 == 0.0) {
                return Double.NaN;
            }
            return d / d2;
        }
    };
    public static final Operator MULTIPLY = new Operator("*"){

        protected double eval(double d, double d2) {
            return d * d2;
        }
    };

    private Operator(String string) {
        this.name = string;
        map.put(string, this);
    }

    protected abstract double eval(double var1, double var3);

    public String toString() {
        return this.name;
    }

    public static Operator toOperator(String string) {
        return map.get(string);
    }

    protected static Set keySet() {
        return map.keySet();
    }
}

