/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace.serial;

import com.sun.jmx.namespace.serial.JMXNamespaceContext;
import com.sun.jmx.namespace.serial.RewritingProcessor;
import com.sun.jmx.namespace.serial.RoutingOnlyProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerialRewritingProcessor
extends RewritingProcessor {
    final String targetPrefix;
    final String sourcePrefix;
    final boolean identity;

    public SerialRewritingProcessor(String string) {
        this(string, null);
    }

    public SerialRewritingProcessor(String string, String string2) {
        super(new RoutingOnlyProcessor(string, string2));
        this.targetPrefix = string;
        this.sourcePrefix = string2;
        this.identity = this.targetPrefix.equals(this.sourcePrefix);
    }

    private <T> T switchContext(T t, String string, String string2) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CloneOutput cloneOutput = new CloneOutput(byteArrayOutputStream);
        JMXNamespaceContext.serialize(cloneOutput, t, string, null);
        cloneOutput.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CloneInput cloneInput = new CloneInput(byteArrayInputStream, cloneOutput);
        Object object = JMXNamespaceContext.deserialize(cloneInput, null, string2);
        return (T)object;
    }

    @Override
    public <T> T rewriteOutput(T t) {
        if (this.identity) {
            return t;
        }
        return (T)this.processOutput(t);
    }

    private Object processOutput(Object object) {
        try {
            if (object instanceof ObjectName) {
                return this.toTargetContext((ObjectName)object);
            }
            return this.switchContext(object, this.sourcePrefix, this.targetPrefix);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can't process result: " + classNotFoundException, classNotFoundException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can't process result: " + iOException, iOException);
        }
    }

    @Override
    public <T> T rewriteInput(T t) {
        if (this.identity) {
            return t;
        }
        return (T)this.processInput(t);
    }

    private Object processInput(Object object) {
        try {
            if (object instanceof ObjectName) {
                return this.toSourceContext((ObjectName)object);
            }
            return this.switchContext(object, this.targetPrefix, this.sourcePrefix);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can't process input: " + classNotFoundException, classNotFoundException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can't process input: " + iOException, iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneInput
    extends ObjectInputStream {
        private final CloneOutput output;

        CloneInput(InputStream inputStream, CloneOutput cloneOutput) throws IOException {
            super(inputStream);
            this.output = cloneOutput;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string;
            Class<?> clazz = this.output.classQueue.poll();
            String string2 = objectStreamClass.getName();
            String string3 = string = clazz == null ? null : clazz.getName();
            if (!string2.equals(string)) {
                throw new InvalidClassException("Classes desynchronized: found " + string + " when expecting " + string2);
            }
            return clazz;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
            return this.output.classQueue.poll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneOutput
    extends ObjectOutputStream {
        Queue<Class<?>> classQueue = new LinkedList();

        CloneOutput(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        @Override
        protected void annotateClass(Class<?> clazz) {
            this.classQueue.add(clazz);
        }

        @Override
        protected void annotateProxyClass(Class<?> clazz) {
            this.classQueue.add(clazz);
        }
    }
}

