/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.messaging.saaj.soap.MessageImpl;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.util.FastInfosetReflection;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastInfosetUtil {
    public static boolean isFastInfosetAccepted(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!FastInfosetUtil.isFastInfosetAccepted(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFastInfosetAccepted(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase("application/fastinfoset")) continue;
            return true;
        }
        return false;
    }

    public static String getFastInfosetFromAccept(List<String> list) {
        for (String string : list) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("application/fastinfoset")) {
                    return "application/fastinfoset";
                }
                if (!string2.equalsIgnoreCase("application/soap+fastinfoset")) continue;
                return "application/soap+fastinfoset";
            }
        }
        return null;
    }

    public static void transcodeXMLStringToFI(String string, OutputStream outputStream) {
        try {
            XmlUtil.newTransformer().transform(new StreamSource(new StringReader(string)), FastInfosetReflection.FastInfosetResult_new(outputStream));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ensureCorrectEncoding(MessageInfo messageInfo, SOAPMessage sOAPMessage) {
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (string == "optimistic") {
            ((MessageImpl)sOAPMessage).setIsFastInfoset(true);
        }
    }
}

