/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKGraphicsUtils;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.AppContext;
import sun.awt.UNIXToolkit;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthIcon;

class GTKStyle
extends SynthStyle
implements GTKConstants {
    private static final String ICON_PROPERTY_PREFIX = "gtk.icon.";
    static final Color BLACK_COLOR = new ColorUIResource(Color.BLACK);
    static final Color WHITE_COLOR = new ColorUIResource(Color.WHITE);
    static final Font DEFAULT_FONT = new FontUIResource("sansserif", 0, 10);
    static final Insets BUTTON_DEFAULT_BORDER_INSETS = new Insets(1, 1, 1, 1);
    private static final GTKGraphicsUtils GTK_GRAPHICS = new GTKGraphicsUtils();
    private static final Map<String, String> CLASS_SPECIFIC_MAP = new HashMap<String, String>();
    private static final Map<String, GTKStockIcon> ICONS_MAP;
    private final Font font;
    private final int widgetType;
    private final int xThickness;
    private final int yThickness;

    private static native int nativeGetXThickness(int var0);

    private static native int nativeGetYThickness(int var0);

    private static native int nativeGetColorForState(int var0, int var1, int var2);

    private static native Object nativeGetClassValue(int var0, String var1);

    private static native String nativeGetPangoFontName(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GTKStyle(Font font, GTKEngine.WidgetType widgetType) {
        String string;
        this.widgetType = widgetType.ordinal();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            this.xThickness = GTKStyle.nativeGetXThickness(this.widgetType);
            this.yThickness = GTKStyle.nativeGetYThickness(this.widgetType);
            string = GTKStyle.nativeGetPangoFontName(this.widgetType);
        }
        object = null;
        if (string != null) {
            object = PangoFonts.lookupFont(string);
        }
        this.font = object != null ? object : (font != null ? font : DEFAULT_FONT);
    }

    public void installDefaults(SynthContext synthContext) {
        super.installDefaults(synthContext);
        if (!synthContext.getRegion().isSubregion()) {
            synthContext.getComponent().putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, GTKLookAndFeel.aaTextInfo);
        }
    }

    public SynthGraphicsUtils getGraphicsUtils(SynthContext synthContext) {
        return GTK_GRAPHICS;
    }

    public SynthPainter getPainter(SynthContext synthContext) {
        return GTKPainter.INSTANCE;
    }

    protected Color getColorForState(SynthContext synthContext, ColorType colorType) {
        if (colorType == ColorType.FOCUS || colorType == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        Region region = synthContext.getRegion();
        int n = synthContext.getComponentState();
        n = GTKLookAndFeel.synthStateToGTKState(region, n);
        if (colorType == ColorType.TEXT_FOREGROUND && (region == Region.BUTTON || region == Region.CHECK_BOX || region == Region.CHECK_BOX_MENU_ITEM || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.TABBED_PANE_TAB || region == Region.TOGGLE_BUTTON || region == Region.TOOL_TIP || region == Region.MENU_ITEM_ACCELERATOR || region == Region.TABBED_PANE_TAB)) {
            colorType = ColorType.FOREGROUND;
        } else if (region == Region.TABLE || region == Region.LIST || region == Region.TREE || region == Region.TREE_CELL) {
            if (colorType == ColorType.FOREGROUND) {
                colorType = ColorType.TEXT_FOREGROUND;
                if (n == 4) {
                    n = 512;
                }
            } else if (colorType == ColorType.BACKGROUND) {
                colorType = ColorType.TEXT_BACKGROUND;
            }
        }
        return this.getStyleSpecificColor(synthContext, n, colorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getStyleSpecificColor(SynthContext synthContext, int n, ColorType colorType) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            int n2 = GTKStyle.nativeGetColorForState(this.widgetType, n, colorType.getID());
            return new ColorUIResource(n2);
        }
    }

    Color getGTKColor(int n, ColorType colorType) {
        return this.getGTKColor(null, n, colorType);
    }

    Color getGTKColor(SynthContext synthContext, int n, ColorType colorType) {
        if (synthContext != null) {
            JComponent jComponent = synthContext.getComponent();
            Region region = synthContext.getRegion();
            n = GTKLookAndFeel.synthStateToGTKState(region, n);
            if (!region.isSubregion() && (n & 1) != 0) {
                Color color;
                if (colorType == ColorType.BACKGROUND || colorType == ColorType.TEXT_BACKGROUND) {
                    Color color2 = jComponent.getBackground();
                    if (!(color2 instanceof UIResource)) {
                        return color2;
                    }
                } else if (!(colorType != ColorType.FOREGROUND && colorType != ColorType.TEXT_FOREGROUND || (color = jComponent.getForeground()) instanceof UIResource)) {
                    return color;
                }
            }
        }
        return this.getStyleSpecificColor(synthContext, n, colorType);
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n = synthContext.getComponentState();
        if (jComponent.getName() == "Table.cellRenderer") {
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
        }
        if (region == Region.LABEL && colorType == ColorType.TEXT_FOREGROUND) {
            colorType = ColorType.FOREGROUND;
        }
        if (!region.isSubregion() && (n & 1) != 0) {
            Color color;
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
            if (colorType == ColorType.TEXT_FOREGROUND && (color = jComponent.getForeground()) != null && !(color instanceof UIResource)) {
                return color;
            }
        }
        return this.getColorForState(synthContext, colorType);
    }

    protected Font getFontForState(SynthContext synthContext) {
        return this.font;
    }

    int getXThickness() {
        return this.xThickness;
    }

    int getYThickness() {
        return this.yThickness;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        String string;
        Region region = synthContext.getRegion();
        JComponent jComponent = synthContext.getComponent();
        String string2 = string = region.isSubregion() ? null : jComponent.getName();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (region == Region.ARROW_BUTTON || region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
                return this.getSimpleInsets(synthContext, insets, 1);
            }
            return this.getButtonInsets(synthContext, insets);
        }
        if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
            return this.getRadioInsets(synthContext, insets);
        }
        if (region == Region.MENU_BAR) {
            return this.getMenuBarInsets(synthContext, insets);
        }
        if (region == Region.MENU || region == Region.MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM) {
            return this.getMenuItemInsets(synthContext, insets);
        }
        if (region == Region.FORMATTED_TEXT_FIELD) {
            return this.getTextFieldInsets(synthContext, insets);
        }
        if (region == Region.INTERNAL_FRAME) {
            insets = Metacity.INSTANCE.getBorderInsets(synthContext, insets);
        } else if (region == Region.LABEL) {
            if ("TableHeader.renderer" == string) {
                return this.getButtonInsets(synthContext, insets);
            }
            if (jComponent instanceof ListCellRenderer) {
                return this.getTextFieldInsets(synthContext, insets);
            }
            if ("Tree.cellRenderer" == string) {
                return this.getSimpleInsets(synthContext, insets, 1);
            }
        } else {
            if (region == Region.OPTION_PANE) {
                return this.getSimpleInsets(synthContext, insets, 6);
            }
            if (region == Region.POPUP_MENU) {
                return this.getSimpleInsets(synthContext, insets, 2);
            }
            if (region == Region.PROGRESS_BAR || region == Region.SLIDER || region == Region.TABBED_PANE || region == Region.TABBED_PANE_CONTENT || region == Region.TOOL_BAR || region == Region.TOOL_BAR_DRAG_WINDOW || region == Region.TOOL_TIP) {
                return this.getThicknessInsets(synthContext, insets);
            }
            if (region == Region.SCROLL_BAR) {
                return this.getScrollBarInsets(synthContext, insets);
            }
            if (region == Region.SLIDER_TRACK) {
                return this.getSliderTrackInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE_TAB) {
                return this.getTabbedPaneTabInsets(synthContext, insets);
            }
            if (region == Region.TEXT_FIELD || region == Region.PASSWORD_FIELD) {
                if (string == "Tree.cellEditor") {
                    return this.getSimpleInsets(synthContext, insets, 1);
                }
                return this.getTextFieldInsets(synthContext, insets);
            }
            if (region == Region.SEPARATOR || region == Region.POPUP_MENU_SEPARATOR || region == Region.TOOL_BAR_SEPARATOR) {
                return this.getSeparatorInsets(synthContext, insets);
            }
            if (region == GTKEngine.CustomRegion.TITLED_BORDER) {
                return this.getThicknessInsets(synthContext, insets);
            }
        }
        return insets;
    }

    private Insets getButtonInsets(SynthContext synthContext, Insets insets) {
        int n = 1;
        int n2 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = this.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n4 = this.getXThickness();
        int n5 = this.getYThickness();
        int n6 = n2 + n3 + n4 + n;
        int n7 = n2 + n3 + n5 + n;
        insets.left = insets.right = n6;
        insets.top = insets.bottom = n7;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JButton && !(jComponent.getParent() instanceof JToolBar) && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets2 = this.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    private Insets getRadioInsets(SynthContext synthContext, Insets insets) {
        int n;
        int n2 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = this.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        insets.top = n = n2 + n3;
        insets.bottom = n;
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            insets.left = 0;
            insets.right = n;
        } else {
            insets.left = n;
            insets.right = 0;
        }
        return insets;
    }

    private Insets getMenuBarInsets(SynthContext synthContext, Insets insets) {
        int n = this.getClassSpecificIntValue(synthContext, "internal-padding", 1);
        int n2 = this.getXThickness();
        int n3 = this.getYThickness();
        insets.left = insets.right = n2 + n;
        insets.top = insets.bottom = n3 + n;
        return insets;
    }

    private Insets getMenuItemInsets(SynthContext synthContext, Insets insets) {
        int n = this.getClassSpecificIntValue(synthContext, "horizontal-padding", 3);
        int n2 = this.getXThickness();
        int n3 = this.getYThickness();
        insets.left = insets.right = n2 + n;
        insets.top = insets.bottom = n3;
        return insets;
    }

    private Insets getThicknessInsets(SynthContext synthContext, Insets insets) {
        insets.left = insets.right = this.getXThickness();
        insets.top = insets.bottom = this.getYThickness();
        return insets;
    }

    private Insets getSeparatorInsets(SynthContext synthContext, Insets insets) {
        int n = 0;
        if (synthContext.getRegion() == Region.POPUP_MENU_SEPARATOR) {
            n = this.getClassSpecificIntValue(synthContext, "horizontal-padding", 3);
        }
        insets.right = insets.left = this.getXThickness() + n;
        insets.top = insets.bottom = this.getYThickness();
        return insets;
    }

    private Insets getSliderTrackInsets(SynthContext synthContext, Insets insets) {
        int n = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n2 = this.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        insets.left = insets.right = n + n2;
        insets.bottom = insets.right;
        insets.top = insets.right;
        return insets;
    }

    private Insets getSimpleInsets(SynthContext synthContext, Insets insets, int n) {
        insets.right = insets.left = n;
        insets.bottom = insets.left;
        insets.top = insets.left;
        return insets;
    }

    private Insets getTabbedPaneTabInsets(SynthContext synthContext, Insets insets) {
        int n = this.getXThickness();
        int n2 = this.getYThickness();
        int n3 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n4 = 2;
        insets.left = insets.right = n3 + n4 + n;
        insets.top = insets.bottom = n3 + n4 + n2;
        return insets;
    }

    private Insets getTextFieldInsets(SynthContext synthContext, Insets insets) {
        insets = this.getClassSpecificInsetsValue(synthContext, "inner-border", this.getSimpleInsets(synthContext, insets, 2));
        int n = this.getXThickness();
        int n2 = this.getYThickness();
        boolean bl = this.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n3 = 0;
        if (!bl) {
            n3 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        }
        insets.left += n3 + n;
        insets.right += n3 + n;
        insets.top += n3 + n2;
        insets.bottom += n3 + n2;
        return insets;
    }

    private Insets getScrollBarInsets(SynthContext synthContext, Insets insets) {
        int n;
        insets.top = insets.bottom = (n = this.getClassSpecificIntValue(synthContext, "trough-border", 1));
        insets.right = insets.bottom;
        insets.left = insets.bottom;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.getParent() instanceof JScrollPane) {
            int n2 = GTKStyle.getClassSpecificIntValue(GTKEngine.WidgetType.SCROLL_PANE, "scrollbar-spacing", 3);
            if (((JScrollBar)jComponent).getOrientation() == 0) {
                insets.top += n2;
            } else if (jComponent.getComponentOrientation().isLeftToRight()) {
                insets.left += n2;
            } else {
                insets.right += n2;
            }
        } else if (jComponent.isFocusable()) {
            int n3 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n4 = this.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            int n5 = n3 + n4;
            insets.left += n5;
            insets.right += n5;
            insets.top += n5;
            insets.bottom += n5;
        }
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getClassSpecificValue(GTKEngine.WidgetType widgetType, String string) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return GTKStyle.nativeGetClassValue(widgetType.ordinal(), string);
        }
    }

    private static int getClassSpecificIntValue(GTKEngine.WidgetType widgetType, String string, int n) {
        Object object = GTKStyle.getClassSpecificValue(widgetType, string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getClassSpecificValue(String string) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return GTKStyle.nativeGetClassValue(this.widgetType, string);
        }
    }

    int getClassSpecificIntValue(SynthContext synthContext, String string, int n) {
        Object object = this.getClassSpecificValue(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n;
    }

    Insets getClassSpecificInsetsValue(SynthContext synthContext, String string, Insets insets) {
        Object object = this.getClassSpecificValue(string);
        if (object instanceof Insets) {
            return (Insets)object;
        }
        return insets;
    }

    boolean getClassSpecificBoolValue(SynthContext synthContext, String string, boolean bl) {
        Object object = this.getClassSpecificValue(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public boolean isOpaque(SynthContext synthContext) {
        Region region = synthContext.getRegion();
        if (region == Region.COMBO_BOX || region == Region.DESKTOP_PANE || region == Region.DESKTOP_ICON || region == Region.EDITOR_PANE || region == Region.FORMATTED_TEXT_FIELD || region == Region.INTERNAL_FRAME || region == Region.LIST || region == Region.MENU_BAR || region == Region.PANEL || region == Region.PASSWORD_FIELD || region == Region.POPUP_MENU || region == Region.PROGRESS_BAR || region == Region.ROOT_PANE || region == Region.SCROLL_PANE || region == Region.SPINNER || region == Region.SPLIT_PANE_DIVIDER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TOOL_BAR_DRAG_WINDOW || region == Region.TOOL_TIP || region == Region.TREE || region == Region.VIEWPORT) {
            return true;
        }
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        return string == "ComboBox.renderer" || string == "ComboBox.listRenderer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(SynthContext synthContext, Object object) {
        Object object2;
        String string = CLASS_SPECIFIC_MAP.get(object);
        if (string != null && (object2 = this.getClassSpecificValue(string)) != null) {
            return object2;
        }
        if (object == "ScrollPane.viewportBorderInsets") {
            return this.getThicknessInsets(synthContext, new Insets(0, 0, 0, 0));
        }
        if (object == "Slider.tickColor") {
            return this.getColorForState(synthContext, ColorType.FOREGROUND);
        }
        if (object == "ScrollBar.minimumThumbSize") {
            int n = this.getClassSpecificIntValue(synthContext, "min-slider-length", 21);
            JScrollBar jScrollBar = (JScrollBar)synthContext.getComponent();
            if (jScrollBar.getOrientation() == 0) {
                return new DimensionUIResource(n, 0);
            }
            return new DimensionUIResource(0, n);
        }
        if (object == "Separator.thickness") {
            object2 = (JSeparator)synthContext.getComponent();
            if (((JSeparator)object2).getOrientation() == 0) {
                return this.getYThickness();
            }
            return this.getXThickness();
        }
        if (object == "ToolBar.separatorSize") {
            int n = GTKStyle.getClassSpecificIntValue(GTKEngine.WidgetType.TOOL_BAR, "space-size", 12);
            return new DimensionUIResource(n, n);
        }
        if (object == "ScrollBar.buttonSize") {
            object2 = (JScrollBar)synthContext.getComponent().getParent();
            boolean bl = ((JScrollBar)object2).getOrientation() == 0;
            GTKEngine.WidgetType widgetType = bl ? GTKEngine.WidgetType.HSCROLL_BAR : GTKEngine.WidgetType.VSCROLL_BAR;
            int n = GTKStyle.getClassSpecificIntValue(widgetType, "slider-width", 14);
            int n2 = GTKStyle.getClassSpecificIntValue(widgetType, "stepper-size", 14);
            return bl ? new DimensionUIResource(n2, n) : new DimensionUIResource(n, n2);
        }
        if (object == "ArrowButton.size") {
            object2 = synthContext.getComponent().getName();
            if (object2 != null && ((String)object2).startsWith("Spinner")) {
                String string2;
                Object object3 = UNIXToolkit.GTK_LOCK;
                synchronized (object3) {
                    string2 = GTKStyle.nativeGetPangoFontName(GTKEngine.WidgetType.SPINNER.ordinal());
                }
                int n = string2 != null ? PangoFonts.getFontSize(string2) : 10;
                return n + this.getXThickness() * 2;
            }
        } else if ("CheckBox.iconTextGap".equals(object) || "RadioButton.iconTextGap".equals(object)) {
            int n = this.getClassSpecificIntValue(synthContext, "indicator-spacing", 2);
            int n3 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n4 = this.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            return n + n3 + n4;
        }
        object2 = null;
        Object object4 = ICONS_MAP;
        synchronized (object4) {
            object2 = ICONS_MAP.get(object);
        }
        if (object2 != null) {
            return object2;
        }
        if (object != "engine") {
            object4 = UIManager.get(object);
            if (object == "Table.rowHeight") {
                int n = this.getClassSpecificIntValue(synthContext, "focus-line-width", 0);
                if (object4 == null && n > 0) {
                    object4 = 16 + 2 * n;
                }
            }
            return object4;
        }
        return null;
    }

    private Icon getStockIcon(SynthContext synthContext, String string, int n) {
        Object object;
        GTKConstants.TextDirection textDirection = GTKConstants.TextDirection.LTR;
        if (synthContext != null && (object = synthContext.getComponent().getComponentOrientation()) != null && !((ComponentOrientation)object).isLeftToRight()) {
            textDirection = GTKConstants.TextDirection.RTL;
        }
        if ((object = this.getStyleSpecificIcon(string, textDirection, n)) != null) {
            return object;
        }
        String string2 = ICON_PROPERTY_PREFIX + string + '.' + n + '.' + (textDirection == GTKConstants.TextDirection.RTL ? "rtl" : "ltr");
        Image image = (Image)Toolkit.getDefaultToolkit().getDesktopProperty(string2);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    private Icon getStyleSpecificIcon(String string, GTKConstants.TextDirection textDirection, int n) {
        UNIXToolkit uNIXToolkit = (UNIXToolkit)Toolkit.getDefaultToolkit();
        BufferedImage bufferedImage = uNIXToolkit.getStockIcon(this.widgetType, string, n, textDirection.ordinal(), null);
        return bufferedImage != null ? new ImageIcon(bufferedImage) : null;
    }

    static {
        CLASS_SPECIFIC_MAP.put("Slider.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("Slider.trackBorder", "trough-border");
        CLASS_SPECIFIC_MAP.put("SplitPane.size", "handle-size");
        CLASS_SPECIFIC_MAP.put("Tree.expanderSize", "expander-size");
        CLASS_SPECIFIC_MAP.put("ScrollBar.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("ScrollBar.width", "slider-width");
        CLASS_SPECIFIC_MAP.put("TextArea.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextArea.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("TextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretAspectRatio", "cursor-aspect-");
        CLASS_SPECIFIC_MAP.put("TextPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextPane.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretAspectRatio", "cursor-aspect-ratio");
        ICONS_MAP = new HashMap<String, GTKStockIcon>();
        ICONS_MAP.put("FileChooser.cancelIcon", new GTKStockIcon("gtk-cancel", 4));
        ICONS_MAP.put("FileChooser.okIcon", new GTKStockIcon("gtk-ok", 4));
        ICONS_MAP.put("OptionPane.errorIcon", new GTKStockIcon("gtk-dialog-error", 6));
        ICONS_MAP.put("OptionPane.informationIcon", new GTKStockIcon("gtk-dialog-info", 6));
        ICONS_MAP.put("OptionPane.warningIcon", new GTKStockIcon("gtk-dialog-warning", 6));
        ICONS_MAP.put("OptionPane.questionIcon", new GTKStockIcon("gtk-dialog-question", 6));
        ICONS_MAP.put("OptionPane.yesIcon", new GTKStockIcon("gtk-yes", 4));
        ICONS_MAP.put("OptionPane.noIcon", new GTKStockIcon("gtk-no", 4));
        ICONS_MAP.put("OptionPane.cancelIcon", new GTKStockIcon("gtk-cancel", 4));
        ICONS_MAP.put("OptionPane.okIcon", new GTKStockIcon("gtk-ok", 4));
    }

    static class GTKLazyValue
    implements UIDefaults.LazyValue {
        private String className;
        private String methodName;

        GTKLazyValue(String string) {
            this(string, null);
        }

        GTKLazyValue(String string, String string2) {
            this.className = string;
            this.methodName = string2;
        }

        public Object createValue(UIDefaults uIDefaults) {
            try {
                Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                if (this.methodName == null) {
                    return clazz.newInstance();
                }
                Method method = clazz.getMethod(this.methodName, null);
                return method.invoke(clazz, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class GTKStockIcon
    extends SynthIcon {
        private String key;
        private int size;
        private boolean loadedLTR;
        private boolean loadedRTL;
        private Icon ltrIcon;
        private Icon rtlIcon;
        private SynthStyle style;

        GTKStockIcon(String string, int n) {
            this.key = string;
            this.size = n;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                if (synthContext == null) {
                    icon.paintIcon(null, graphics, n, n2);
                } else {
                    icon.paintIcon(synthContext.getComponent(), graphics, n, n2);
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 0;
        }

        public int getIconHeight(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconHeight();
            }
            return 0;
        }

        private Icon getIcon(SynthContext synthContext) {
            if (synthContext != null) {
                ComponentOrientation componentOrientation = synthContext.getComponent().getComponentOrientation();
                SynthStyle synthStyle = synthContext.getStyle();
                if (synthStyle != this.style) {
                    this.style = synthStyle;
                    this.loadedRTL = false;
                    this.loadedLTR = false;
                }
                if (componentOrientation == null || componentOrientation.isLeftToRight()) {
                    if (!this.loadedLTR) {
                        this.loadedLTR = true;
                        this.ltrIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                    }
                    return this.ltrIcon;
                }
                if (!this.loadedRTL) {
                    this.loadedRTL = true;
                    this.rtlIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                }
                return this.rtlIcon;
            }
            return this.ltrIcon;
        }
    }

    static class GTKStockIconInfo {
        private static Map<String, Integer> ICON_TYPE_MAP;
        private static final Object ICON_SIZE_KEY;

        GTKStockIconInfo() {
        }

        private static Dimension[] getIconSizesMap() {
            AppContext appContext = AppContext.getAppContext();
            Dimension[] dimensionArray = (Dimension[])appContext.get(ICON_SIZE_KEY);
            if (dimensionArray == null) {
                dimensionArray = new Dimension[]{null, new Dimension(16, 16), new Dimension(18, 18), new Dimension(24, 24), new Dimension(20, 20), new Dimension(32, 32), new Dimension(48, 48)};
                appContext.put(ICON_SIZE_KEY, dimensionArray);
            }
            return dimensionArray;
        }

        public static Dimension getIconSize(int n) {
            Dimension[] dimensionArray = GTKStockIconInfo.getIconSizesMap();
            return n >= 0 && n < dimensionArray.length ? dimensionArray[n] : null;
        }

        public static void setIconSize(int n, int n2, int n3) {
            Dimension[] dimensionArray = GTKStockIconInfo.getIconSizesMap();
            if (n >= 0 && n < dimensionArray.length) {
                dimensionArray[n] = new Dimension(n2, n3);
            }
        }

        public static int getIconType(String string) {
            Integer n;
            if (string == null) {
                return -100;
            }
            if (ICON_TYPE_MAP == null) {
                GTKStockIconInfo.initIconTypeMap();
            }
            return (n = ICON_TYPE_MAP.get(string)) != null ? n : -100;
        }

        private static void initIconTypeMap() {
            ICON_TYPE_MAP = new HashMap<String, Integer>();
            ICON_TYPE_MAP.put("gtk-menu", 1);
            ICON_TYPE_MAP.put("gtk-small-toolbar", 2);
            ICON_TYPE_MAP.put("gtk-large-toolbar", 3);
            ICON_TYPE_MAP.put("gtk-button", 4);
            ICON_TYPE_MAP.put("gtk-dnd", 5);
            ICON_TYPE_MAP.put("gtk-dialog", 6);
        }

        static {
            ICON_SIZE_KEY = new StringBuffer("IconSize");
        }
    }
}

