/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.event.DaemonThreadFactory;
import com.sun.jmx.event.RepeatedSingletonJob;
import com.sun.jmx.remote.util.ClassLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.Notification;
import javax.management.event.EventForwarder;
import javax.management.event.FetchingEventRelay;
import javax.management.event.RMIPushServer;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class RMIPushEventForwarder
implements EventForwarder {
    private static final int DEFAULT_BUFFER_SIZE = 6000;
    private long passed = 0L;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory("JMX RMIEventForwarder Executor"));
    private final SendingJob sendingJob = new SendingJob();
    private final BlockingQueue<TargetedNotification> buffer;
    private final RMIPushServer receiver;
    private boolean ended = false;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "RMIEventForwarder");

    public RMIPushEventForwarder(RMIPushServer rMIPushServer, int n) {
        if (logger.traceOn()) {
            logger.trace("RMIEventForwarder", "new one");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size: " + n);
        }
        if (n == 0) {
            n = 6000;
        }
        if (rMIPushServer == null) {
            throw new NullPointerException();
        }
        this.receiver = rMIPushServer;
        this.buffer = new ArrayBlockingQueue<TargetedNotification>(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(Notification notification, Integer n) {
        if (logger.traceOn()) {
            logger.trace("forward", "to the listener: " + n);
        }
        SendingJob sendingJob = this.sendingJob;
        synchronized (sendingJob) {
            TargetedNotification targetedNotification = new TargetedNotification(notification, n);
            while (!this.buffer.offer(targetedNotification)) {
                this.buffer.remove();
                ++this.passed;
            }
            this.sendingJob.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (logger.traceOn()) {
            logger.trace("close", "called");
        }
        SendingJob sendingJob = this.sendingJob;
        synchronized (sendingJob) {
            this.ended = true;
            this.buffer.clear();
        }
    }

    public void setClientId(String string) {
        if (logger.traceOn()) {
            logger.trace("setClientId", string);
        }
    }

    private class SendingJob
    extends RepeatedSingletonJob {
        public SendingJob() {
            super(executor);
        }

        public boolean isSuspended() {
            return RMIPushEventForwarder.this.ended || RMIPushEventForwarder.this.buffer.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void task() {
            block14: {
                long l = RMIPushEventForwarder.this.passed;
                ArrayList arrayList = new ArrayList(RMIPushEventForwarder.this.buffer.size());
                TargetedNotification[] targetedNotificationArray = RMIPushEventForwarder.this.sendingJob;
                synchronized (targetedNotificationArray) {
                    RMIPushEventForwarder.this.buffer.drainTo(arrayList);
                    RMIPushEventForwarder.this.passed += arrayList.size();
                }
                if (logger.traceOn()) {
                    logger.trace("SendingJob-task", "sending: " + arrayList.size());
                }
                if (!arrayList.isEmpty()) {
                    try {
                        targetedNotificationArray = new TargetedNotification[arrayList.size()];
                        arrayList.toArray(targetedNotificationArray);
                        RMIPushEventForwarder.this.receiver.receive(new NotificationResult(l, RMIPushEventForwarder.this.passed, targetedNotificationArray));
                    }
                    catch (RemoteException remoteException) {
                        if (logger.debugOn()) {
                            logger.debug("SendingJob-task", "Got exception to forward notifs.", remoteException);
                        }
                        long l2 = RMIPushEventForwarder.this.passed - l;
                        if (FetchingEventRelay.isSerialOrClassNotFound(remoteException)) {
                            long l3 = l;
                            for (TargetedNotification targetedNotification : arrayList) {
                                try {
                                    RMIPushEventForwarder.this.receiver.receive(new NotificationResult(l, ++l3, new TargetedNotification[]{targetedNotification}));
                                }
                                catch (RemoteException remoteException2) {
                                    logger.trace("SendingJob-task", "send to remote", remoteException2);
                                }
                            }
                            l2 = RMIPushEventForwarder.this.passed - l3;
                        }
                        if (l2 <= 0L) break block14;
                        try {
                            RMIPushEventForwarder.this.receiver.receive(new NotificationResult(RMIPushEventForwarder.this.passed, RMIPushEventForwarder.this.passed, new TargetedNotification[0]));
                        }
                        catch (RemoteException remoteException3) {
                            logger.trace("SendingJob-task", "receiver.receive", remoteException3);
                        }
                    }
                }
            }
        }
    }
}

