/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private static long lastRefresh = -1L;
    private static final int TIMEOUT = 300000;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private LinkedList searchlist;
    private LinkedList nameservers;

    private LinkedList resolvconf(String string, int n, int n2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/resolv.conf"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                int n3 = n;
                if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';' || !string2.startsWith(string) || (string4 = string2.substring(string.length())).length() == 0 || string4.charAt(0) != ' ' && string4.charAt(0) != '\t') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                while (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).charAt(0) != '#' && string3.charAt(0) != ';') {
                    linkedList.add(string3);
                    if (--n3 != 0) continue;
                    break;
                }
                if (--n2 != 0) continue;
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }

    private void loadConfig() {
        long l;
        assert (Thread.holdsLock(lock));
        if (lastRefresh >= 0L && (l = System.currentTimeMillis()) - lastRefresh < 300000L) {
            return;
        }
        this.nameservers = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResolverConfigurationImpl.this.resolvconf("nameserver", 1, 5);
            }
        });
        this.searchlist = this.getSearchList();
        lastRefresh = System.currentTimeMillis();
    }

    private LinkedList getSearchList() {
        LinkedList<String> linkedList = (LinkedList<String>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("search", 6, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        String string = ResolverConfigurationImpl.localDomain0();
        if (string != null && string.length() > 0) {
            linkedList = new LinkedList<String>();
            linkedList.add(string);
            return linkedList;
        }
        linkedList = (LinkedList<String>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("domain", 1, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList<String>();
        String string2 = ResolverConfigurationImpl.fallbackDomain0();
        if (string2 != null && string2.length() > 0) {
            linkedList.add(string2);
        }
        return linkedList;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.nameservers.clone();
        }
    }

    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native String localDomain0();

    static native String fallbackDomain0();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

