/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.jdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.jdt.internal.core.builder.MissingClassFileException;
import org.eclipse.jdt.internal.core.builder.MissingSourceFileException;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaBuilder
extends IncrementalProjectBuilder {
    IProject currentProject;
    JavaProject javaProject;
    IWorkspaceRoot workspaceRoot;
    NameEnvironment nameEnvironment;
    SimpleLookupTable binaryLocationsPerProject;
    State lastState;
    BuildNotifier notifier;
    char[][] extraResourceFileFilters;
    String[] extraResourceFolderFilters;
    public static boolean DEBUG = false;
    static ArrayList builtProjects = null;

    public static IMarker[] getProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                return resource.findMarkers("org.eclipse.jdt.core.problem", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new IMarker[0];
    }

    public static IMarker[] getTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                return resource.findMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new IMarker[0];
    }

    public static void buildStarting() {
    }

    public static void buildFinished() {
        BuildNotifier.resetProblemCounters();
    }

    public static void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void removeTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        return State.read(project, in);
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map ignored, IProgressMonitor monitor) throws CoreException {
        block36: {
            this.currentProject = this.getProject();
            if (this.currentProject == null || !this.currentProject.isAccessible()) {
                return new IProject[0];
            }
            if (DEBUG) {
                System.out.println("\nStarting build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
            }
            this.notifier = new BuildNotifier(monitor, this.currentProject);
            this.notifier.begin();
            boolean ok = false;
            try {
                block35: {
                    try {
                        this.notifier.checkCancel();
                        this.initializeBuilder();
                        if (!this.isWorthBuilding()) break block35;
                        if (kind == 6) {
                            this.buildAll();
                        } else {
                            this.lastState = this.getLastState(this.currentProject);
                            if (this.lastState == null) {
                                if (DEBUG) {
                                    System.out.println("Performing full build since last saved state was not found");
                                }
                                this.buildAll();
                            } else if (this.hasClasspathChanged()) {
                                this.buildAll();
                            } else if (this.nameEnvironment.sourceLocations.length > 0) {
                                SimpleLookupTable deltas = this.findDeltas();
                                if (deltas == null) {
                                    this.buildAll();
                                } else if (deltas.elementSize > 0) {
                                    this.buildDeltas(deltas);
                                } else if (DEBUG) {
                                    System.out.println("Nothing to build since deltas were empty");
                                }
                            } else if (this.hasStructuralDelta()) {
                                this.buildAll();
                            } else {
                                if (DEBUG) {
                                    System.out.println("Nothing to build since there are no source folders and no deltas");
                                }
                                this.lastState.tagAsNoopBuild();
                            }
                        }
                        ok = true;
                    }
                    catch (CoreException e) {
                        Util.log(e, "JavaBuilder handling CoreException while building: " + this.currentProject.getName());
                        IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
                        marker.setAttribute("message", (Object)Util.bind("build.inconsistentProject", e.getLocalizedMessage()));
                        marker.setAttribute("severity", 2);
                        Object var8_11 = null;
                        if (!ok) {
                            this.clearLastState();
                        }
                        this.notifier.done();
                        this.cleanup();
                        break block36;
                    }
                    catch (ImageBuilderInternalException e) {
                        Util.log(e.getThrowable(), "JavaBuilder handling ImageBuilderInternalException while building: " + this.currentProject.getName());
                        IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
                        marker.setAttribute("message", (Object)Util.bind("build.inconsistentProject", e.getLocalizedMessage()));
                        marker.setAttribute("severity", 2);
                        Object var8_12 = null;
                        if (!ok) {
                            this.clearLastState();
                        }
                        this.notifier.done();
                        this.cleanup();
                        break block36;
                    }
                    catch (MissingClassFileException e) {
                        if (DEBUG) {
                            System.out.println(Util.bind("build.incompleteClassPath", e.missingClassFile));
                        }
                        IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
                        marker.setAttribute("message", (Object)Util.bind("build.incompleteClassPath", e.missingClassFile));
                        marker.setAttribute("severity", 2);
                        Object var8_13 = null;
                        if (!ok) {
                            this.clearLastState();
                        }
                        this.notifier.done();
                        this.cleanup();
                        break block36;
                    }
                    catch (MissingSourceFileException e) {
                        if (DEBUG) {
                            System.out.println(Util.bind("build.missingSourceFile", e.missingSourceFile));
                        }
                        JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
                        IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
                        marker.setAttribute("message", (Object)Util.bind("build.missingSourceFile", e.missingSourceFile));
                        marker.setAttribute("severity", 2);
                        Object var8_14 = null;
                        if (!ok) {
                            this.clearLastState();
                        }
                        this.notifier.done();
                        this.cleanup();
                    }
                }
                Object var8_10 = null;
                if (!ok) {
                    this.clearLastState();
                }
                this.notifier.done();
                this.cleanup();
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                if (!ok) {
                    this.clearLastState();
                }
                this.notifier.done();
                this.cleanup();
                throw throwable;
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        if (DEBUG) {
            System.out.println("Finished build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        return requiredProjects;
    }

    private void buildAll() {
        this.notifier.checkCancel();
        this.notifier.subTask(Util.bind("build.preparingBuild"));
        if (DEBUG && this.lastState != null) {
            System.out.println("Clearing last state : " + this.lastState);
        }
        this.clearLastState();
        BatchImageBuilder imageBuilder = new BatchImageBuilder(this);
        imageBuilder.build();
        this.recordNewState(imageBuilder.newState);
    }

    private void buildDeltas(SimpleLookupTable deltas) {
        this.notifier.checkCancel();
        this.notifier.subTask(Util.bind("build.preparingBuild"));
        if (DEBUG && this.lastState != null) {
            System.out.println("Clearing last state : " + this.lastState);
        }
        this.clearLastState();
        IncrementalImageBuilder imageBuilder = new IncrementalImageBuilder(this);
        if (imageBuilder.build(deltas)) {
            this.recordNewState(imageBuilder.newState);
        } else {
            this.buildAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        if (DEBUG) {
            System.out.println("\nCleaning " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        this.notifier = new BuildNotifier(monitor, this.currentProject);
        this.notifier.begin();
        try {
            this.notifier.checkCancel();
            this.initializeBuilder();
            if (DEBUG) {
                System.out.println("Clearing last state as part of clean : " + this.lastState);
            }
            this.clearLastState();
            JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            new BatchImageBuilder(this).cleanOutputFolders(false);
        }
        catch (CoreException e) {
            Util.log(e, "JavaBuilder handling CoreException while cleaning: " + this.currentProject.getName());
            IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
            marker.setAttribute("message", (Object)Util.bind("build.inconsistentProject", e.getLocalizedMessage()));
            marker.setAttribute("severity", 2);
        }
        finally {
            this.notifier.done();
            this.cleanup();
        }
        if (DEBUG) {
            System.out.println("Finished cleaning " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
    }

    private void cleanup() {
        this.nameEnvironment = null;
        this.binaryLocationsPerProject = null;
        this.lastState = null;
        this.notifier = null;
        this.extraResourceFileFilters = null;
        this.extraResourceFolderFilters = null;
    }

    private void clearLastState() {
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, null);
    }

    boolean filterExtraResource(IResource resource) {
        if (this.extraResourceFileFilters != null) {
            char[] name = resource.getName().toCharArray();
            int l = this.extraResourceFileFilters.length;
            for (int i = 0; i < l; ++i) {
                if (!CharOperation.match(this.extraResourceFileFilters[i], name, true)) continue;
                return true;
            }
        }
        if (this.extraResourceFolderFilters != null) {
            IPath path = resource.getProjectRelativePath();
            String pathName = path.toString();
            int count = path.segmentCount();
            if (resource.getType() == 1) {
                --count;
            }
            int l = this.extraResourceFolderFilters.length;
            for (int i = 0; i < l; ++i) {
                if (pathName.indexOf(this.extraResourceFolderFilters[i]) == -1) continue;
                for (int j = 0; j < count; ++j) {
                    if (!this.extraResourceFolderFilters[i].equals(path.segment(j))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private SimpleLookupTable findDeltas() {
        this.notifier.subTask(Util.bind("build.readingDelta", this.currentProject.getName()));
        IResourceDelta delta = this.getDelta(this.currentProject);
        SimpleLookupTable deltas = new SimpleLookupTable(3);
        if (delta != null) {
            if (delta.getKind() != 0) {
                if (DEBUG) {
                    System.out.println("Found source delta for: " + this.currentProject.getName());
                }
                deltas.put(this.currentProject, delta);
            }
        } else {
            if (DEBUG) {
                System.out.println("Missing delta for: " + this.currentProject.getName());
            }
            this.notifier.subTask("");
            return null;
        }
        Object[] keyTable = this.binaryLocationsPerProject.keyTable;
        Object[] valueTable = this.binaryLocationsPerProject.valueTable;
        int l = keyTable.length;
        for (int i = 0; i < l; ++i) {
            IProject p = (IProject)keyTable[i];
            if (p == null || p == this.currentProject) continue;
            State s = this.getLastState(p);
            if (!this.lastState.wasStructurallyChanged(p, s)) {
                if (s.wasNoopBuild()) continue;
                ClasspathLocation[] classFoldersAndJars = (ClasspathLocation[])valueTable[i];
                boolean canSkip = true;
                int m = classFoldersAndJars.length;
                for (int j = 0; j < m; ++j) {
                    if (classFoldersAndJars[j].isOutputFolder()) {
                        classFoldersAndJars[j] = null;
                        continue;
                    }
                    canSkip = false;
                }
                if (canSkip) continue;
            }
            this.notifier.subTask(Util.bind("build.readingDelta", p.getName()));
            delta = this.getDelta(p);
            if (delta != null) {
                if (delta.getKind() == 0) continue;
                if (DEBUG) {
                    System.out.println("Found binary delta for: " + p.getName());
                }
                deltas.put(p, delta);
                continue;
            }
            if (DEBUG) {
                System.out.println("Missing delta for: " + p.getName());
            }
            this.notifier.subTask("");
            return null;
        }
        this.notifier.subTask("");
        return deltas;
    }

    public State getLastState(IProject project) {
        return (State)JavaModelManager.getJavaModelManager().getLastBuiltState(project, this.notifier.monitor);
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.javaProject == null || this.workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = this.javaProject.getExpandedClasspath(true);
            int l = entries.length;
            for (int i = 0; i < l; ++i) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = this.workspaceRoot.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = this.workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p == null || projects.contains(p)) continue;
                projects.add(p);
            }
        }
        catch (JavaModelException e) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private boolean hasClasspathChanged() {
        int n;
        ClasspathMultiDirectory[] newSourceLocations = this.nameEnvironment.sourceLocations;
        ClasspathMultiDirectory[] oldSourceLocations = this.lastState.sourceLocations;
        int newLength = newSourceLocations.length;
        int oldLength = oldSourceLocations.length;
        int o = 0;
        for (n = 0; n < newLength && o < oldLength; ++n, ++o) {
            if (newSourceLocations[n].equals(oldSourceLocations[o])) continue;
            try {
                if (newSourceLocations[n].sourceFolder.members().length == 0) {
                    --o;
                    continue;
                }
            }
            catch (CoreException ignore) {
                // empty catch block
            }
            if (DEBUG) {
                System.out.println(newSourceLocations[n] + " != " + oldSourceLocations[o]);
            }
            return true;
        }
        while (n < newLength) {
            try {
                if (newSourceLocations[n].sourceFolder.members().length == 0) {
                    ++n;
                    continue;
                }
            }
            catch (CoreException ignore) {
                // empty catch block
            }
            if (DEBUG) {
                System.out.println("Added non-empty source folder");
            }
            return true;
        }
        if (o < oldLength) {
            if (DEBUG) {
                System.out.println("Removed source folder");
            }
            return true;
        }
        ClasspathLocation[] newBinaryLocations = this.nameEnvironment.binaryLocations;
        ClasspathLocation[] oldBinaryLocations = this.lastState.binaryLocations;
        newLength = newBinaryLocations.length;
        oldLength = oldBinaryLocations.length;
        o = 0;
        for (n = 0; n < newLength && o < oldLength; ++n, ++o) {
            if (newBinaryLocations[n].equals(oldBinaryLocations[o])) continue;
            if (DEBUG) {
                System.out.println(newBinaryLocations[n] + " != " + oldBinaryLocations[o]);
            }
            return true;
        }
        if (n < newLength || o < oldLength) {
            if (DEBUG) {
                System.out.println("Number of binary folders/jar files has changed");
            }
            return true;
        }
        return false;
    }

    private boolean hasStructuralDelta() {
        ClasspathLocation[] classFoldersAndJars;
        IResourceDelta delta = this.getDelta(this.currentProject);
        if (delta != null && delta.getKind() != 0 && (classFoldersAndJars = (ClasspathLocation[])this.binaryLocationsPerProject.get(this.currentProject)) != null) {
            int l = classFoldersAndJars.length;
            for (int i = 0; i < l; ++i) {
                IResourceDelta binaryDelta;
                IPath p;
                ClasspathLocation classFolderOrJar = classFoldersAndJars[i];
                if (classFolderOrJar == null || (p = classFolderOrJar.getProjectRelativePath()) == null || (binaryDelta = delta.findMember(p)) == null || binaryDelta.getKind() == 0) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeBuilder() throws CoreException {
        char[][] filters;
        this.javaProject = (JavaProject)JavaCore.create(this.currentProject);
        this.workspaceRoot = this.currentProject.getWorkspace().getRoot();
        String projectName = this.currentProject.getName();
        if (builtProjects == null || builtProjects.contains(projectName)) {
            JavaModel.flushExternalFileCache();
            builtProjects = new ArrayList();
        }
        builtProjects.add(projectName);
        this.binaryLocationsPerProject = new SimpleLookupTable(3);
        this.nameEnvironment = new NameEnvironment(this.workspaceRoot, this.javaProject, this.binaryLocationsPerProject);
        String filterSequence = this.javaProject.getOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", true);
        char[][] cArray = filters = filterSequence != null && filterSequence.length() > 0 ? CharOperation.splitAndTrimOn(',', filterSequence.toCharArray()) : (char[][])null;
        if (filters == null) {
            this.extraResourceFileFilters = null;
            this.extraResourceFolderFilters = null;
        } else {
            char[] f;
            int i;
            int fileCount = 0;
            int folderCount = 0;
            int l = filters.length;
            for (i = 0; i < l; ++i) {
                f = filters[i];
                if (f.length == 0) continue;
                if (f[f.length - 1] == '/') {
                    ++folderCount;
                    continue;
                }
                ++fileCount;
            }
            this.extraResourceFileFilters = new char[fileCount][];
            this.extraResourceFolderFilters = new String[folderCount];
            l = filters.length;
            for (i = 0; i < l; ++i) {
                f = filters[i];
                if (f.length == 0) continue;
                if (f[f.length - 1] == '/') {
                    this.extraResourceFolderFilters[--folderCount] = new String(CharOperation.subarray(f, 0, f.length - 1));
                    continue;
                }
                this.extraResourceFileFilters[--fileCount] = f;
            }
        }
    }

    private boolean isClasspathBroken(IClasspathEntry[] classpath, IProject p) throws CoreException {
        if (classpath == JavaProject.INVALID_CLASSPATH) {
            return true;
        }
        IMarker[] markers = p.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
        int l = markers.length;
        for (int i = 0; i < l; ++i) {
            if ((Integer)markers[i].getAttribute("severity") != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isWorthBuilding() throws CoreException {
        boolean abortBuilds = "abort".equals(this.javaProject.getOption("org.eclipse.jdt.core.builder.invalidClasspath", true));
        if (!abortBuilds) {
            return true;
        }
        if (this.isClasspathBroken(this.javaProject.getRawClasspath(), this.currentProject)) {
            if (DEBUG) {
                System.out.println("Aborted build because project has classpath errors (incomplete or involved in cycle)");
            }
            JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
            marker.setAttribute("message", (Object)Util.bind("build.abortDueToClasspathProblems"));
            marker.setAttribute("severity", 2);
            return false;
        }
        IProject[] requiredProjects = this.getRequiredProjects(false);
        int l = requiredProjects.length;
        for (int i = 0; i < l; ++i) {
            JavaProject prereq;
            IProject p = requiredProjects[i];
            if (this.getLastState(p) != null || (prereq = (JavaProject)JavaCore.create(p)).hasCycleMarker() && "warning".equals(this.javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true))) continue;
            if (DEBUG) {
                System.out.println("Aborted build because prereq project " + p.getName() + " was not built");
            }
            JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            IMarker marker = this.currentProject.createMarker("org.eclipse.jdt.core.problem");
            marker.setAttribute("message", (Object)(this.isClasspathBroken(prereq.getRawClasspath(), p) ? Util.bind("build.prereqProjectHasClasspathProblems", p.getName()) : Util.bind("build.prereqProjectMustBeRebuilt", p.getName())));
            marker.setAttribute("severity", 2);
            return false;
        }
        return true;
    }

    void mustPropagateStructuralChanges() {
        HashSet cycleParticipants = new HashSet(3);
        this.javaProject.updateCycleParticipants(new ArrayList(), cycleParticipants, this.workspaceRoot, new HashSet(3), null);
        IPath currentPath = this.javaProject.getPath();
        Iterator i = cycleParticipants.iterator();
        while (i.hasNext()) {
            IProject project;
            IPath participantPath = (IPath)i.next();
            if (participantPath == currentPath || !this.hasBeenBuilt(project = this.workspaceRoot.getProject(participantPath.segment(0)))) continue;
            if (DEBUG) {
                System.out.println("Requesting another build iteration since cycle participant " + project.getName() + " has not yet seen some structural changes");
            }
            this.needRebuild();
            return;
        }
    }

    private void recordNewState(State state) {
        Object[] keyTable = this.binaryLocationsPerProject.keyTable;
        int l = keyTable.length;
        for (int i = 0; i < l; ++i) {
            IProject prereqProject = (IProject)keyTable[i];
            if (prereqProject == null || prereqProject == this.currentProject) continue;
            state.recordStructuralDependency(prereqProject, this.getLastState(prereqProject));
        }
        if (DEBUG) {
            System.out.println("Recording new state : " + state);
        }
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, state);
    }

    public String toString() {
        return this.currentProject == null ? "JavaBuilder for unknown project" : "JavaBuilder for " + this.currentProject.getName();
    }
}

