/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    char[] packageName = CharOperation.NO_CHAR;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer indexer) {
        this.indexer = indexer;
    }

    public void acceptConstructorReference(char[] typeName, int argCount, int sourcePosition) {
        this.indexer.addConstructorReference(typeName, argCount);
        int lastDot = CharOperation.lastIndexOf('.', typeName);
        if (lastDot != -1) {
            char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(typeName, 0, lastDot));
            int length = qualification.length;
            for (int i = 0; i < length; ++i) {
                this.indexer.addNameReference(qualification[i]);
            }
        }
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(name, 0, CharOperation.lastIndexOf('.', name)));
        int length = qualification.length;
        for (int i = 0; i < length; ++i) {
            this.indexer.addNameReference(qualification[i]);
        }
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.packageName = name;
    }

    public void acceptProblem(IProblem problem) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        for (int i = 0; i < length - 1; ++i) {
            this.acceptUnknownReference(typeName[i], 0);
        }
        this.acceptTypeReference(typeName[length - 1], 0);
    }

    public void acceptTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        for (int i = 0; i < name.length; ++i) {
            this.acceptUnknownReference(name[i], 0);
        }
    }

    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        if (superclass != null) {
            superclass = CharOperation.lastSegment(superclass, '.');
            this.indexer.addConstructorReference(superclass, 0);
        }
        if (superinterfaces != null) {
            int length = superinterfaces.length;
            for (int i = 0; i < length; ++i) {
                superinterfaces[i] = CharOperation.lastSegment(superinterfaces[i], '.');
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? IIndexConstants.ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addClassDeclaration(modifiers, this.packageName, name, typeNames, superclass, superinterfaces);
        this.pushTypeName(name);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.indexer.addConstructorDeclaration(name, parameterTypes, exceptionTypes);
        ++this.methodDepth;
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        this.indexer.addFieldDeclaration(type, name);
        ++this.methodDepth;
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        ++this.methodDepth;
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        if (superinterfaces != null) {
            int length = superinterfaces.length;
            for (int i = 0; i < length; ++i) {
                superinterfaces[i] = CharOperation.lastSegment(superinterfaces[i], '.');
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? IIndexConstants.ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addInterfaceDeclaration(modifiers, this.packageName, name, typeNames, superinterfaces);
        this.pushTypeName(name);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.indexer.addMethodDeclaration(name, parameterTypes, returnType, exceptionTypes);
        ++this.methodDepth;
    }

    public void exitClass(int declarationEnd) {
        this.popTypeName();
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        --this.methodDepth;
    }

    public void exitInitializer(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitInterface(int declarationEnd) {
        this.popTypeName();
    }

    public void exitMethod(int declarationEnd) {
        --this.methodDepth;
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        } else if (JobManager.VERBOSE) {
            try {
                this.enclosingTypeNames[-1] = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    public void pushTypeName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }
}

