/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.AddStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class Add
extends Command {
    protected Add() {
    }

    protected String getRequestId() {
        return "add";
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        for (int i = 0; i < resources.length; ++i) {
            Assert.isNotNull(resources[i].getRemoteLocation(session.getLocalRoot()));
        }
        AddStructureVisitor visitor = new AddStructureVisitor(session);
        visitor.visit(session, resources, monitor);
        return resources;
    }

    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].isFolder()) continue;
            ICVSFolder mFolder = (ICVSFolder)resources[i];
            FolderSyncInfo info = mFolder.getParent().getFolderSyncInfo();
            if (info == null) {
                status = this.mergeStatus(status, (IStatus)new CVSStatus(4, Policy.bind("Add.invalidParent", mFolder.getRelativePath(session.getLocalRoot()))));
                continue;
            }
            String repository = info.getRepository() + "/" + mFolder.getName();
            mFolder.setFolderSyncInfo(new FolderSyncInfo(repository, info.getRoot(), info.getTag(), info.getIsStatic()));
        }
        return status;
    }
}

