/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.console.actions.TextViewerGotoLineAction;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.MessageConsoleViewer;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MessageConsolePage
implements IPageBookViewPage,
IAdaptable,
IPropertyChangeListener {
    private IPageSite fSite = null;
    private MessageConsoleViewer fViewer = null;
    private IConsoleView fView;
    private MessageConsole fConsole;
    private ISelectionChangedListener fTextListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MessageConsolePage.this.updateSelectionDependentActions();
        }
    };
    private ClearOutputAction fClearOutputAction;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private Menu fMenu;
    static /* synthetic */ Class class$org$eclipse$jface$text$IFindReplaceTarget;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Widget;

    public MessageConsolePage(IConsoleView view, MessageConsole console) {
        this.fView = view;
        this.fConsole = console;
    }

    public IPageSite getSite() {
        return this.fSite;
    }

    public void init(IPageSite site) {
        this.fSite = site;
    }

    public void createControl(Composite parent) {
        this.fViewer = new MessageConsoleViewer(parent);
        this.fViewer.setDocument(this.getConsole().getDocument());
        this.fViewer.getTextWidget().setTabs(this.getConsole().getTabWidth());
        MenuManager manager = new MenuManager("#MessageConsole", "#MessageConsole");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                MessageConsolePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(ConsolePlugin.getUniqueIdentifier() + ".messageConsole", manager, (ISelectionProvider)this.getViewer());
        site.setSelectionProvider((ISelectionProvider)this.getViewer());
        this.createActions();
        this.configureToolBar(this.getSite().getActionBars().getToolBarManager());
        this.fViewer.getSelectionProvider().addSelectionChangedListener(this.fTextListener);
        this.setFont(this.getConsole().getFont());
        this.getConsole().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String property = event.getProperty();
        if (source.equals(this.getConsole()) && MessageConsole.P_FONT.equals(property)) {
            this.setFont(this.getConsole().getFont());
        } else if (MessageConsole.P_STREAM_COLOR.equals(property) && source instanceof MessageConsoleStream) {
            MessageConsoleStream stream = (MessageConsoleStream)source;
            if (stream.getConsole().equals(this.getConsole())) {
                this.getViewer().getTextWidget().redraw();
            }
        } else if (source.equals(this.getConsole()) && property.equals(MessageConsole.P_TAB_SIZE) && this.fViewer != null) {
            this.fViewer.getTextWidget().setTabs(this.getConsole().getTabWidth());
            this.fViewer.getTextWidget().redraw();
        }
    }

    public void dispose() {
        this.getConsole().removePropertyChangeListener(this);
        this.fViewer.getSelectionProvider().removeSelectionChangedListener(this.fTextListener);
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fViewer != null) {
            this.fViewer.dispose();
            this.fViewer = null;
        }
        this.fSite = null;
        this.fSelectionActions.clear();
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        menu.add((IAction)this.fGlobalActions.get("GotoLine"));
        menu.add((IAction)this.fClearOutputAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        if (this.fViewer != null) {
            return this.fViewer.getControl();
        }
        return null;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
        this.updateSelectionDependentActions();
    }

    protected void createActions() {
        this.fClearOutputAction = new ClearOutputAction((ITextViewer)this.getViewer());
        IActionBars actionBars = this.getSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getViewer(), 4);
        action.configureAction(ConsoleMessages.getString("MessageConsolePage.&Copy@Ctrl+C_6"), ConsoleMessages.getString("MessageConsolePage.Copy_7"), ConsoleMessages.getString("MessageConsolePage.Copy_7"));
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getViewer(), 7);
        action.configureAction(ConsoleMessages.getString("MessageConsolePage.Select_&All@Ctrl+A_12"), ConsoleMessages.getString("MessageConsolePage.Select_All"), ConsoleMessages.getString("MessageConsolePage.Select_All"));
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ui.internal.console.ConsoleMessages");
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this.getConsoleView()));
        action = new TextViewerGotoLineAction((ITextViewer)this.getViewer());
        this.setGlobalAction(actionBars, "GotoLine", (IAction)action);
        actionBars.updateActionBars();
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected MessageConsoleViewer getViewer() {
        return this.fViewer;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("outputGroup", (IAction)this.fClearOutputAction);
    }

    protected IConsoleView getConsoleView() {
        return this.fView;
    }

    protected MessageConsole getConsole() {
        return this.fConsole;
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$jface$text$IFindReplaceTarget == null ? (class$org$eclipse$jface$text$IFindReplaceTarget = MessageConsolePage.class$("org.eclipse.jface.text.IFindReplaceTarget")) : class$org$eclipse$jface$text$IFindReplaceTarget).equals(required)) {
            return this.getViewer().getFindReplaceTarget();
        }
        if ((class$org$eclipse$swt$widgets$Widget == null ? (class$org$eclipse$swt$widgets$Widget = MessageConsolePage.class$("org.eclipse.swt.widgets.Widget")) : class$org$eclipse$swt$widgets$Widget).equals(required)) {
            return this.getViewer().getTextWidget();
        }
        return null;
    }

    protected void setFont(Font font) {
        this.getViewer().getTextWidget().setFont(font);
    }

    protected void refresh() {
        this.getViewer().refresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

