/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSUtil {
    private NLSUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readString(InputStream is) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, "8859_1"));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        Object var7_7 = null;
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return string;
        catch (IOException iOException) {
            try {
                Object var7_8 = null;
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException ex) {}
            return null;
        }
    }

    public static TextEdit createNLSEdit(ICompilationUnit cu, int position) throws JavaModelException {
        NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, position);
        if (nlsLine == null) {
            return null;
        }
        NLSElement element = NLSUtil.findElement(nlsLine, position);
        if (element.hasTag()) {
            return null;
        }
        NLSElement[] elements = nlsLine.getElements();
        int indexInElementList = Arrays.asList(elements).indexOf(element);
        int editOffset = NLSUtil.computeInsertOffset(elements, indexInElementList, cu);
        String editText = " " + NLSElement.createTagText(indexInElementList + 1);
        return new InsertEdit(editOffset, editText);
    }

    private static NLSLine scanCurrentLine(ICompilationUnit cu, int position) throws JavaModelException {
        try {
            Assert.isTrue(position >= 0 && position <= cu.getSourceRange().getLength());
            NLSLine[] allLines = NLSScanner.scan(cu);
            for (int i = 0; i < allLines.length; ++i) {
                NLSLine line = allLines[i];
                if (NLSUtil.findElement(line, position) == null) continue;
                return line;
            }
            return null;
        }
        catch (InvalidInputException e) {
            return null;
        }
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        Region elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] elements = line.getElements();
        for (int i = 0; i < elements.length; ++i) {
            NLSElement element = elements[i];
            if (!NLSUtil.isPositionInElement(element, position)) continue;
            return element;
        }
        return null;
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, ICompilationUnit cu) throws JavaModelException {
        NLSElement previousTagged = NLSUtil.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSUtil.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return NLSUtil.findLineEnd(cu, elements[index].getPosition().getOffset());
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        for (int i = startIndex - 1; i >= 0; --i) {
            if (!elements[i].hasTag()) continue;
            return elements[i];
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        for (int i = startIndex + 1; i < elements.length; ++i) {
            if (!elements[i].hasTag()) continue;
            return elements[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findLineEnd(ICompilationUnit cu, int position) throws JavaModelException {
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.create(cu.getBuffer().getContents());
            TextRegion lineInfo = buffer.getLineInformationOfOffset(position);
            int n = lineInfo.getOffset() + lineInfo.getLength();
            return n;
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }
}

