/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

class CopyCallHierarchyAction
extends Action {
    private static final char INDENTATION = '\t';
    private CallHierarchyViewPart fView;
    private CallHierarchyViewer fViewer;
    private final Clipboard fClipboard;

    public CopyCallHierarchyAction(CallHierarchyViewPart view, Clipboard clipboard, CallHierarchyViewer viewer) {
        super(CallHierarchyMessages.getString("CopyCallHierarchyAction.label"));
        Assert.isNotNull((Object)clipboard);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_copy_action_context");
        this.fView = view;
        this.fClipboard = clipboard;
        this.fViewer = viewer;
    }

    public void run() {
        block3: {
            StringBuffer buf = new StringBuffer();
            this.addCalls(this.fViewer.getTree().getSelection()[0], 0, buf);
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(buf.toString())}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getViewSite().getShell(), (String)CallHierarchyMessages.getString("CopyCallHierarchyAction.problem"), (String)CallHierarchyMessages.getString("CopyCallHierarchyAction.clipboard_busy"))) break block3;
                this.run();
            }
        }
    }

    private void addCalls(TreeItem item, int indent, StringBuffer buf) {
        for (int i = 0; i < indent; ++i) {
            buf.append('\t');
        }
        buf.append(item.getText());
        buf.append('\n');
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.addCalls(items[i], indent + 1, buf);
            }
        }
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException e) {
            return in;
        }
        return stringWriter.toString();
    }
}

