/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map fListenerGroups = new HashMap();
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener == null) {
            partListener = new PartListenerGroup(part);
            this.fListenerGroups.put(part, partListener);
        }
        partListener.install(listener);
    }

    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.uninstall(listener);
            if (partListener.isEmpty()) {
                this.fListenerGroups.remove(part);
            }
        }
    }

    public void forceSelectionChange(ITextEditor part, ITextSelection selection) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.firePostSelectionChanged(selection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionChangedListener fSelectionListener;
        private ISelectionChangedListener fPostSelectionListener;
        private Job fCurrentJob;
        private ListenerList fAstListeners;

        public PartListenerGroup(ITextEditor part) {
            this.fPart = part;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList();
            this.fSelectionListener = new ISelectionChangedListener(this){
                private final /* synthetic */ PartListenerGroup this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        this.this$0.fireSelectionChanged((ITextSelection)selection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionChangedListener(this){
                private final /* synthetic */ PartListenerGroup this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        this.this$0.firePostSelectionChanged((ITextSelection)selection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            ISelectionProvider selectionProvider;
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.addSelectionChangedListener(this.fSelectionListener);
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            ISelectionProvider selectionProvider;
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(ITextSelection selection) {
            IJavaElement input;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((input = this.getJavaElement()) == null) {
                return;
            }
            this.fCurrentJob = new Job(this, JavaUIMessages.getString("SelectionListenerWithASTManager.job.title"), input, selection){
                private final /* synthetic */ IJavaElement val$input;
                private final /* synthetic */ ITextSelection val$selection;
                private final /* synthetic */ PartListenerGroup this$0;
                {
                    this.this$0 = this$0;
                    this.val$input = val$input;
                    this.val$selection = val$selection;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    PartListenerGroup partListenerGroup = this.this$0;
                    synchronized (partListenerGroup) {
                        return this.this$0.calculateASTandInform(this.val$input, this.val$selection, monitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        private IJavaElement getJavaElement() {
            IEditorInput editorInput = this.fPart.getEditorInput();
            if (editorInput != null) {
                return (IJavaElement)editorInput.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = SelectionListenerWithASTManager.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
            }
            return null;
        }

        protected IStatus calculateASTandInform(IJavaElement input, ITextSelection selection, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST(input, true, monitor);
                if (astRoot != null && !monitor.isCanceled()) {
                    Object[] listeners = this.fAstListeners.getListeners();
                    for (int i = 0; i < listeners.length; ++i) {
                        ((ISelectionListenerWithAST)listeners[i]).selectionChanged((IEditorPart)this.fPart, selection, astRoot);
                        if (!monitor.isCanceled()) continue;
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }
            catch (OperationCanceledException e) {
                // empty catch block
            }
            return Status.CANCEL_STATUS;
        }
    }
}

