/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.locators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.sisu.reflect.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassRealmUtils {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;
    private static Map<ClassRealm, Set<String>> namesCache;

    private ClassRealmUtils() {
    }

    public static ClassRealm contextRealm() {
        for (ClassLoader tccl = Thread.currentThread().getContextClassLoader(); tccl != null; tccl = tccl.getParent()) {
            if (!(tccl instanceof ClassRealm)) continue;
            return (ClassRealm)tccl;
        }
        return null;
    }

    public static Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (GET_IMPORT_REALMS_SUPPORTED && null != contextRealm) {
            Set<String> names = namesCache.get(contextRealm);
            if (null == names) {
                names = ClassRealmUtils.computeVisibleNames(contextRealm);
                namesCache.put(contextRealm, names);
            }
            return names;
        }
        return null;
    }

    private static Set<String> computeVisibleNames(ClassRealm forRealm) {
        HashSet<String> visibleRealmNames = new HashSet<String>();
        ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
        searchRealms.add(forRealm);
        for (int i = 0; i < searchRealms.size(); ++i) {
            ClassRealm realm = (ClassRealm)searchRealms.get(i);
            if (!visibleRealmNames.add(realm.toString())) continue;
            searchRealms.addAll(realm.getImportRealms());
            ClassRealm parent = realm.getParentRealm();
            if (null == parent) continue;
            searchRealms.add(parent);
        }
        return visibleRealmNames;
    }

    static {
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Exception e) {
            getImportRealmsSupported = false;
        }
        catch (LinkageError e) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
        namesCache = Weak.concurrentKeys();
    }
}

