/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.InProcessCompiler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=InProcessCompiler.class)
public class JavaxToolsCompiler
extends AbstractLogEnabled
implements InProcessCompiler {
    private final JavaCompiler COMPILER = this.newJavaCompiler();
    private final List<JavaCompiler> JAVA_COMPILERS = new CopyOnWriteArrayList<JavaCompiler>();

    protected JavaCompiler newJavaCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaCompiler getJavaCompiler(CompilerConfiguration compilerConfiguration) {
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.newJavaCompiler();
            }
            case ReuseCreated: {
                List<JavaCompiler> list = this.JAVA_COMPILERS;
                synchronized (list) {
                    if (this.JAVA_COMPILERS.size() > 0) {
                        JavaCompiler javaCompiler = this.JAVA_COMPILERS.get(0);
                        this.JAVA_COMPILERS.remove(javaCompiler);
                        return javaCompiler;
                    }
                }
                JavaCompiler javaCompiler = this.newJavaCompiler();
                return javaCompiler;
            }
        }
        return this.COMPILER;
    }

    private void releaseJavaCompiler(JavaCompiler javaCompiler, CompilerConfiguration compilerConfiguration) {
        if (javaCompiler == null) {
            return;
        }
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.JAVA_COMPILERS.add(javaCompiler);
        }
    }

    @Override
    public CompilerResult compileInProcess(String[] args, CompilerConfiguration config, String[] sourceFiles) throws CompilerException {
        JavaCompiler compiler = this.getJavaCompiler(config);
        try {
            CompilerResult compilerResult;
            block21: {
                if (compiler == null) {
                    CompilerMessage message = new CompilerMessage("No compiler is provided in this environment. Perhaps you are running on a JRE rather than a JDK?", CompilerMessage.Kind.ERROR);
                    CompilerResult compilerResult2 = new CompilerResult(false, Collections.singletonList(message));
                    return compilerResult2;
                }
                String sourceEncoding = config.getSourceEncoding();
                Charset sourceCharset = sourceEncoding == null ? null : Charset.forName(sourceEncoding);
                DiagnosticCollector collector = new DiagnosticCollector();
                StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(collector, null, sourceCharset);
                try {
                    Iterable<? extends JavaFileObject> fileObjects = standardFileManager.getJavaFileObjectsFromStrings(Arrays.asList(sourceFiles));
                    List<String> arguments = Arrays.asList(args);
                    JavaCompiler.CompilationTask task = compiler.getTask(null, standardFileManager, collector, arguments, null, fileObjects);
                    Boolean result = task.call();
                    ArrayList<CompilerMessage> compilerMsgs = new ArrayList<CompilerMessage>();
                    for (Diagnostic diagnostic : collector.getDiagnostics()) {
                        String baseMessage;
                        CompilerMessage.Kind kind = this.convertKind(diagnostic);
                        try {
                            baseMessage = diagnostic.getMessage(Locale.getDefault());
                        }
                        catch (AssertionError e) {
                            this.getLogger().debug("Ignore Issue get JavaCompiler Diagnostic message (see https://bugs.openjdk.java.net/browse/JDK-8210649):" + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                            baseMessage = diagnostic.toString();
                        }
                        if (baseMessage == null) continue;
                        JavaFileObject source = (JavaFileObject)diagnostic.getSource();
                        String longFileName = source == null ? null : source.toUri().getPath();
                        String shortFileName = source == null ? null : source.getName();
                        String formattedMessage = baseMessage;
                        int lineNumber = Math.max(0, (int)diagnostic.getLineNumber());
                        int columnNumber = Math.max(0, (int)diagnostic.getColumnNumber());
                        if (source != null && lineNumber > 0) {
                            String possibleTrimming = longFileName + ":" + lineNumber + ": ";
                            if (formattedMessage.startsWith(possibleTrimming)) {
                                formattedMessage = formattedMessage.substring(possibleTrimming.length());
                            } else {
                                possibleTrimming = shortFileName + ":" + lineNumber + ": ";
                                if (formattedMessage.startsWith(possibleTrimming)) {
                                    formattedMessage = formattedMessage.substring(possibleTrimming.length());
                                }
                            }
                        }
                        compilerMsgs.add(new CompilerMessage(longFileName, kind, lineNumber, columnNumber, lineNumber, columnNumber, formattedMessage));
                    }
                    if (result != Boolean.TRUE && compilerMsgs.isEmpty()) {
                        compilerMsgs.add(new CompilerMessage("An unknown compilation problem occurred", CompilerMessage.Kind.ERROR));
                    }
                    compilerResult = new CompilerResult(result.booleanValue(), compilerMsgs);
                    if (standardFileManager == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (standardFileManager != null) {
                            try {
                                standardFileManager.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new CompilerException(e.getMessage(), (Throwable)e);
                    }
                }
                standardFileManager.close();
            }
            return compilerResult;
        }
        finally {
            this.releaseJavaCompiler(compiler, config);
        }
    }

    private CompilerMessage.Kind convertKind(Diagnostic<? extends JavaFileObject> diagnostic) {
        CompilerMessage.Kind kind;
        switch (diagnostic.getKind()) {
            case ERROR: {
                kind = CompilerMessage.Kind.ERROR;
                break;
            }
            case WARNING: {
                kind = CompilerMessage.Kind.WARNING;
                break;
            }
            case MANDATORY_WARNING: {
                kind = CompilerMessage.Kind.MANDATORY_WARNING;
                break;
            }
            case NOTE: {
                kind = CompilerMessage.Kind.NOTE;
                break;
            }
            default: {
                kind = CompilerMessage.Kind.OTHER;
            }
        }
        return kind;
    }
}

