#include <sys/param.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


int
main(int argc, char **argv)
{
	int fd, n;
	char buffer[128];

	if (argc != 2)
		errx(1, "Usage: %s file", argv[0]);
	
	fd = open(argv[1], O_WRONLY);
	if (fd < 0)
		err(1, "open: %s", argv[1]);

	lseek(fd, 0, SEEK_SET);
	memset(buffer, 'a', sizeof(buffer));

	n = write(fd, buffer, sizeof(buffer));
	if (n == -1)
		err(1, "write");
	else if (n != sizeof(buffer))
		errx(1, "write returned %d", n);

	close(fd);
}
