# $Id: progs.mk,v 1.3 2006/12/29 22:24:26 sjg Exp $
#
#	@(#) Copyright (c) 2006, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

.MAIN: all

.if defined(PROGS)

.ifndef PROG
.for p in ${PROGS}
.if make($p)
PROG?= $p
.else
$p: ${SRCS} ${DPADD} ${DPLIBS} ${SRCS_$p} ${DPLIBS_$p}
	(cd ${.CURDIR} && ${.MAKE} -f ${MAKEFILE} PROG=$p)
.endif
.endfor
.endif

.if defined(PROG)
# just one of many
.for v in DPLIBS SRCS CFLAGS ${PROG_VARS}
$v += ${${v}_${PROG}}
.endfor
# prog.mk will do the rest
.elif make(all)
# we don't need/want prog.mk in this case
__skip_prog_mk__:
all: ${PROGS} .MAKE
.endif
.endif

.if !target(__skip_prog_mk__)
# handle being called [bsd.]progs.mk
.include <${.PARSEFILE:S,progs,prog,}>
.endif
