"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/anomaly_detectors';
const AD_NODE_API = exports.AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${BASE_NODE_API_PATH}/_indices_and_aliases`
});
const ALERTING_NODE_API = exports.ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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