/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

public class ShellCommandException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorCode code;
    private String command;

    public ShellCommandException(ErrorCode code, String command) {
        this.code = code;
        this.command = command;
    }

    @Override
    public String getMessage() {
        return String.valueOf((Object)this.code) + (String)(this.command != null ? " (" + this.command + ")" : "");
    }

    public static enum ErrorCode {
        UNKNOWN_ERROR("Unknown error"),
        UNSUPPORTED_LANGUAGE("Programming language used is not supported"),
        UNRECOGNIZED_COMMAND("Command is not supported"),
        INITIALIZATION_FAILURE("Command could not be initialized"),
        XML_PARSING_ERROR("Failed to parse the XML file");

        private String description;

        private ErrorCode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

