/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.gc;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;

public class GcVolumeUtil {
    static final String ALL_VOLUMES_PREFIX = "agcav:/";

    public static Collection<Path> expandAllVolumesUri(VolumeManager fs, Path path) {
        if (path.toString().startsWith(ALL_VOLUMES_PREFIX)) {
            String relPath = path.toString().substring(ALL_VOLUMES_PREFIX.length());
            return fs.getVolumes().stream().map(vol -> vol.prefixChild(relPath)).collect(Collectors.toList());
        }
        return Collections.singleton(path);
    }

    public static boolean isAllVolumesUri(Path path) {
        return path.toString().startsWith(ALL_VOLUMES_PREFIX);
    }
}

