/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.camel.util.BufferCaster;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    public static Supplier<Charset> defaultCharset = Charset::defaultCharset;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final long INITIAL_OFFSET = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(IOHelper.class);
    private static final boolean ZERO_BYTE_EOL_ENABLED = "true".equalsIgnoreCase(System.getProperty("camel.zeroByteEOLEnabled", "true"));

    private IOHelper() {
    }

    public static BufferedInputStream buffered(InputStream in) {
        BufferedInputStream bi;
        return in instanceof BufferedInputStream ? (bi = (BufferedInputStream)in) : new BufferedInputStream(in);
    }

    public static BufferedOutputStream buffered(OutputStream out) {
        BufferedOutputStream bo;
        return out instanceof BufferedOutputStream ? (bo = (BufferedOutputStream)out) : new BufferedOutputStream(out);
    }

    public static BufferedReader buffered(Reader reader) {
        BufferedReader br;
        return reader instanceof BufferedReader ? (br = (BufferedReader)reader) : new BufferedReader(reader);
    }

    public static BufferedWriter buffered(Writer writer) {
        BufferedWriter bw;
        return writer instanceof BufferedWriter ? (bw = (BufferedWriter)writer) : new BufferedWriter(writer);
    }

    public static String toString(Reader reader) throws IOException {
        return IOHelper.toString(reader, 0L);
    }

    public static String toString(Reader reader, long offset) throws IOException {
        return IOHelper.toString(IOHelper.buffered(reader), offset);
    }

    public static String toString(BufferedReader reader) throws IOException {
        return IOHelper.toString(reader, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(BufferedReader reader, long offset) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        reader.skip(offset);
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close((Closeable)reader, "reader", LOG);
        }
        return sb.toString();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int copied = (int)input.transferTo(output);
        output.flush();
        return copied;
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOHelper.copy(input, output, bufferSize, false);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean flushOnEachWrite) throws IOException {
        return IOHelper.copy(input, output, bufferSize, flushOnEachWrite, -1L);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean flushOnEachWrite, long maxSize) throws IOException {
        boolean hasData;
        if (input instanceof ByteArrayInputStream) {
            input.mark(0);
            input.reset();
            bufferSize = input.available();
        } else {
            int avail = input.available();
            if (avail > bufferSize) {
                bufferSize = avail;
            }
        }
        if (bufferSize > 262144) {
            bufferSize = 262144;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copying InputStream: {} -> OutputStream: {} with buffer: {} and flush on each write {}", new Object[]{input, output, bufferSize, flushOnEachWrite});
        }
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        if (ZERO_BYTE_EOL_ENABLED) {
            hasData = n > 0;
        } else {
            boolean bl = hasData = n > -1;
        }
        if (hasData) {
            while (-1 != n) {
                output.write(buffer, 0, n);
                if (flushOnEachWrite) {
                    output.flush();
                }
                if (maxSize > 0L && (long)(total += n) > maxSize) {
                    throw new IOException("The InputStream entry being copied exceeds the maximum allowed size");
                }
                n = input.read(buffer);
            }
        }
        if (!flushOnEachWrite) {
            output.flush();
        }
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        IOHelper.copy(input, output);
        IOHelper.close((Closeable)input, null, LOG);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        IOHelper.copy(input, output, bufferSize);
        IOHelper.close((Closeable)input, null, LOG);
    }

    public static int copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void transfer(ReadableByteChannel input, WritableByteChannel output) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        while (input.read(buffer) >= 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                output.write(buffer);
            }
            buffer.clear();
        }
    }

    public static void force(FileChannel channel, String name, Logger log) {
        try {
            if (channel != null) {
                channel.force(true);
            }
        }
        catch (Exception e) {
            if (log == null) {
                log = LOG;
            }
            if (name != null) {
                log.debug("Cannot force FileChannel: {}. Reason: {}", new Object[]{name, e.getMessage(), e});
            }
            log.debug("Cannot force FileChannel. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void force(FileOutputStream os, String name, Logger log) {
        try {
            if (os != null) {
                os.getFD().sync();
            }
        }
        catch (Exception e) {
            if (log == null) {
                log = LOG;
            }
            if (name != null) {
                log.debug("Cannot sync FileDescriptor: {}. Reason: {}", new Object[]{name, e.getMessage(), e});
            }
            log.debug("Cannot sync FileDescriptor. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void close(Writer writer, FileOutputStream os, String name, Logger log, boolean force) {
        if (writer != null && force) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                if (log == null) {
                    log = LOG;
                }
                if (name != null) {
                    log.debug("Cannot flush Writer: {}. Reason: {}", new Object[]{name, e.getMessage(), e});
                }
                log.debug("Cannot flush Writer. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
            IOHelper.force(os, name, log);
        }
        IOHelper.close((Closeable)writer, name, log);
    }

    public static void close(Closeable closeable, String name, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (log == null) {
                    log = LOG;
                }
                if (name != null) {
                    log.debug("Cannot close: {}. Reason: {}", new Object[]{name, e.getMessage(), e});
                }
                log.debug("Cannot close. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void closeWithException(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(FileChannel channel, String name, Logger log, boolean force) {
        if (force) {
            IOHelper.force(channel, name, log);
        }
        IOHelper.close((Closeable)channel, name, log);
    }

    public static void close(Closeable closeable, String name) {
        IOHelper.close(closeable, name, LOG);
    }

    public static void close(Closeable closeable) {
        IOHelper.close(closeable, null, LOG);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOHelper.close(closeable);
        }
    }

    public static void closeIterator(Object it) throws IOException {
        Scanner scanner;
        IOException ioException;
        if (it instanceof Closeable) {
            Closeable closeable = (Closeable)it;
            IOHelper.closeWithException(closeable);
        }
        if (it instanceof Scanner && (ioException = (scanner = (Scanner)it).ioException()) != null) {
            throw ioException;
        }
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        String string;
        StringBuilder builder = new StringBuilder(2048);
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader = IOHelper.buffered(isr);
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            IOHelper.close(isr, in);
            throw throwable;
        }
        IOHelper.close(isr, in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextLine(InputStream in, int lineNumber) throws IOException {
        String string;
        int i = 0;
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader = IOHelper.buffered(isr);
            while ((line = reader.readLine()) != null) {
                if (++i < lineNumber) break block4;
                string = line;
            }
        }
        catch (Throwable throwable) {
            IOHelper.close(isr, in);
            throw throwable;
        }
        {
            block4: {
                IOHelper.close(isr, in);
                return string;
            }
            continue;
        }
        IOHelper.close(isr, in);
        return null;
    }

    public static void appendText(String text, File file) throws IOException {
        IOHelper.doWriteText(text, file, true);
    }

    public static void writeText(String text, File file) throws IOException {
        IOHelper.doWriteText(text, file, false);
    }

    private static void doWriteText(String text, File file, boolean append) throws IOException {
        String path;
        if (!file.exists() && (path = FileUtil.onlyPath(file.getPath())) != null) {
            new File(path).mkdirs();
        }
        IOHelper.writeText(text, new FileOutputStream(file, append));
    }

    public static void writeText(String text, OutputStream os) throws IOException {
        try {
            os.write(text.getBytes());
        }
        finally {
            IOHelper.close((Closeable)os);
        }
    }

    public static String getCharsetNameFromContentType(String contentType) {
        String[] values;
        int pos = contentType.indexOf("charset=");
        if (pos != -1) {
            if (contentType.regionMatches(true, pos + 8, "utf-8", 0, 5)) {
                return "UTF-8";
            }
            int end = contentType.indexOf(59, pos);
            String charset = end > pos ? contentType.substring(pos + 8, end) : contentType.substring(pos + 8);
            return IOHelper.normalizeCharset(charset);
        }
        for (String value : values = contentType.split(";")) {
            String prefix;
            if (!(value = value.trim()).regionMatches(true, 0, prefix = "charset=", 0, prefix.length())) continue;
            String charset = value.substring(8);
            return IOHelper.normalizeCharset(charset);
        }
        return "UTF-8";
    }

    public static String normalizeCharset(String charset) {
        if (charset != null) {
            boolean trim = false;
            String answer = charset.trim();
            if (answer.startsWith("'") || answer.startsWith("\"")) {
                answer = answer.substring(1);
                trim = true;
            }
            if (answer.endsWith("'") || answer.endsWith("\"")) {
                answer = answer.substring(0, answer.length() - 1);
                trim = true;
            }
            return trim ? answer.trim() : answer;
        }
        return null;
    }

    public static String lookupEnvironmentVariable(String key) {
        String upperKey = key.toUpperCase();
        String value = System.getenv(upperKey);
        if (value == null) {
            value = System.getenv(IOHelper.normalizeEnvironmentVariable(upperKey));
        }
        if (value == null) {
            String caseKey = StringHelper.camelCaseToDash(key);
            value = System.getenv(IOHelper.normalizeEnvironmentVariable(caseKey));
        }
        return value;
    }

    public static String normalizeEnvironmentVariable(String key) {
        String upperKey = key.toUpperCase();
        String normalizedKey = upperKey.replace('-', '_');
        return normalizedKey.replace('.', '_');
    }

    public static InputStream toInputStream(File file, String charset) throws IOException {
        return IOHelper.toInputStream(file.toPath(), charset);
    }

    public static InputStream toInputStream(Path file, String charset) throws IOException {
        if (charset != null) {
            return new EncodingInputStream(file, charset);
        }
        return IOHelper.buffered(Files.newInputStream(file, new OpenOption[0]));
    }

    public static BufferedReader toReader(Path file, String charset) throws IOException {
        return IOHelper.toReader(file, charset != null ? Charset.forName(charset) : null);
    }

    public static BufferedReader toReader(File file, String charset) throws IOException {
        return IOHelper.toReader(file, charset != null ? Charset.forName(charset) : null);
    }

    public static BufferedReader toReader(File file, Charset charset) throws IOException {
        return IOHelper.toReader(file.toPath(), charset);
    }

    public static BufferedReader toReader(Path file, Charset charset) throws IOException {
        if (charset != null) {
            return Files.newBufferedReader(file, charset);
        }
        return Files.newBufferedReader(file);
    }

    public static BufferedWriter toWriter(FileOutputStream os, String charset) throws IOException {
        return IOHelper.buffered(new EncodingFileWriter(os, charset));
    }

    public static BufferedWriter toWriter(FileOutputStream os, Charset charset) {
        return IOHelper.buffered(new EncodingFileWriter(os, charset));
    }

    public static String stripLineComments(Path path, String commentPrefix, boolean stripBlankLines) {
        StringBuilder result = new StringBuilder(2048);
        try (Stream<String> lines = Files.lines(path);){
            lines.filter(l -> !stripBlankLines || !l.isBlank()).filter(line -> !line.startsWith(commentPrefix)).forEach(line -> result.append((String)line).append('\n'));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + String.valueOf(path), e);
        }
        return result.toString();
    }

    public static class EncodingInputStream
    extends InputStream {
        private final Lock lock = new ReentrantLock();
        private final Path file;
        private final BufferedReader reader;
        private final Charset defaultStreamCharset;
        private ByteBuffer bufferBytes;
        private final CharBuffer bufferedChars = CharBuffer.allocate(4096);

        public EncodingInputStream(Path file, String charset) throws IOException {
            this.file = file;
            this.reader = IOHelper.toReader(file, charset);
            this.defaultStreamCharset = defaultCharset.get();
        }

        @Override
        public int read() throws IOException {
            if (this.bufferBytes == null || this.bufferBytes.remaining() <= 0) {
                BufferCaster.cast(this.bufferedChars).clear();
                int len = this.reader.read(this.bufferedChars);
                this.bufferedChars.flip();
                if (len == -1) {
                    return -1;
                }
                this.bufferBytes = this.defaultStreamCharset.encode(this.bufferedChars);
            }
            return this.bufferBytes.get() & 0xFF;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public void reset() throws IOException {
            this.lock.lock();
            try {
                this.reader.reset();
            }
            finally {
                this.lock.unlock();
            }
        }

        public InputStream toOriginalInputStream() throws IOException {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
    }

    public static class EncodingFileWriter
    extends OutputStreamWriter {
        private final FileOutputStream out;

        public EncodingFileWriter(FileOutputStream out, String charset) throws UnsupportedEncodingException {
            super((OutputStream)out, charset);
            this.out = out;
        }

        public EncodingFileWriter(FileOutputStream out, Charset charset) {
            super((OutputStream)out, charset);
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.out.close();
            }
        }
    }

    public static class EncodingFileReader
    extends InputStreamReader {
        private final FileInputStream in;

        public EncodingFileReader(FileInputStream in, String charset) throws UnsupportedEncodingException {
            super((InputStream)in, charset);
            this.in = in;
        }

        public EncodingFileReader(FileInputStream in, Charset charset) {
            super((InputStream)in, charset);
            this.in = in;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.in.close();
            }
        }
    }
}

