/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagementSupport;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.qpid.proton.engine.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final ActiveMQServer server;
    private final AMQPBrokerConnection brokerConnection;
    private final WildcardConfiguration wildcardConfiguration;
    private final ScheduledExecutorService scheduler;
    private final Map<String, Object> properties;
    private final Map<String, Predicate<Link>> linkClosedinterceptors = new ConcurrentHashMap<String, Predicate<Link>>();
    private final Set<AMQPBridgePolicyManager> policyManagers = new HashSet<AMQPBridgePolicyManager>();
    private final AMQPBridgeMetrics metrics = new AMQPBridgeMetrics();
    private volatile AMQPBridgeConfiguration configuration;
    protected volatile State state = State.UNINITIALIZED;
    protected volatile boolean connected;

    AMQPBridgeManager(String name, AMQPBrokerConnection brokerConnection, Set<AMQPBridgeAddressPolicy> fromAddressPolicies, Set<AMQPBridgeAddressPolicy> toAddressPolicies, Set<AMQPBridgeQueuePolicy> fromQueuePolicies, Set<AMQPBridgeQueuePolicy> toQueuePolicies, Map<String, Object> properties) {
        Objects.requireNonNull(name, "Bridge name cannot be null");
        this.name = name;
        this.server = brokerConnection.getServer();
        this.brokerConnection = brokerConnection;
        this.brokerConnection.addLinkClosedInterceptor(this.getName(), this::invokeLinkClosedInterceptors);
        this.scheduler = this.server.getScheduledPool();
        this.properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        fromAddressPolicies.forEach(policy -> this.policyManagers.add(new AMQPBridgeFromAddressPolicyManager(this, this.metrics.newPolicyMetrics(), (AMQPBridgeAddressPolicy)policy)));
        fromQueuePolicies.forEach(policy -> this.policyManagers.add(new AMQPBridgeFromQueuePolicyManager(this, this.metrics.newPolicyMetrics(), (AMQPBridgeQueuePolicy)policy)));
        toAddressPolicies.forEach(policy -> this.policyManagers.add(new AMQPBridgeToAddressPolicyManager(this, this.metrics.newPolicyMetrics(), (AMQPBridgeAddressPolicy)policy)));
        toQueuePolicies.forEach(policy -> this.policyManagers.add(new AMQPBridgeToQueuePolicyManager(this, this.metrics.newPolicyMetrics(), (AMQPBridgeQueuePolicy)policy)));
        this.wildcardConfiguration = this.server.getConfiguration().getWildcardConfiguration() != null ? this.server.getConfiguration().getWildcardConfiguration() : WildcardConfiguration.DEFAULT_WILDCARD_CONFIGURATION;
    }

    public final synchronized void initialize() throws ActiveMQException {
        this.failIfShutdown();
        if (this.state == State.UNINITIALIZED) {
            this.state = State.STOPPED;
            try {
                AMQPBridgeManagementSupport.registerBridgeManager(this);
            }
            catch (Exception e) {
                logger.warn("Ignoring error while attempting to register bridge with management services");
            }
            for (AMQPBridgePolicyManager manager : this.policyManagers) {
                manager.initialize();
            }
        }
    }

    public final synchronized void start() throws ActiveMQException {
        this.failIfShutdown();
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            throw new ActiveMQIllegalStateException("The bridge has not been initialized and cannot be started.");
        }
        if (this.state == State.STOPPED) {
            this.state = State.STARTED;
            for (AMQPBridgePolicyManager manager : this.policyManagers) {
                try {
                    manager.start();
                }
                catch (Exception e) {
                    logger.debug("Caught error while starting a policy manager: ", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public final synchronized void stop() throws ActiveMQException {
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            throw new ActiveMQIllegalStateException("The bridge has not been initialized and cannot be stopped.");
        }
        if (this.state == State.STARTED) {
            this.state = State.STOPPED;
            for (AMQPBridgePolicyManager manager : this.policyManagers) {
                try {
                    manager.stop();
                }
                catch (Exception e) {
                    logger.debug("Caught error while stopping a policy manager: ", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public final synchronized void shutdown() throws ActiveMQException {
        if (this.state.ordinal() < State.SHUTDOWN.ordinal()) {
            this.state = State.SHUTDOWN;
            try {
                AMQPBridgeManagementSupport.unregisterBridgeManager(this);
            }
            catch (Exception e) {
                logger.warn("Ignoring error while attempting to unregister bridge with management services");
            }
            for (AMQPBridgePolicyManager manager : this.policyManagers) {
                manager.shutdown();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AMQPBridgeMetrics getMetrics() {
        return this.metrics;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connectionInterrupted() throws ActiveMQException {
        AtomicReference errorCaught = new AtomicReference();
        this.policyManagers.forEach(manager -> {
            try {
                manager.connectionInterrupted();
            }
            catch (Exception ex) {
                logger.trace("Exception caught on from a policy manager connection state update: ", (Throwable)ex);
                errorCaught.compareAndExchange(null, ex);
            }
        });
        if (errorCaught.get() != null) {
            Exception error = (Exception)errorCaught.get();
            if (error instanceof ActiveMQException) {
                throw (ActiveMQException)((Object)error);
            }
            throw (ActiveMQException)new ActiveMQException(error.getMessage()).initCause((Throwable)error);
        }
    }

    public synchronized void connectionRestored(AMQPConnectionContext connection, AMQPSessionContext session) throws ActiveMQException {
        this.configuration = new AMQPBridgeConfiguration(connection, this.properties);
        for (AMQPBridgePolicyManager manager : this.policyManagers) {
            try {
                manager.connectionRestored(session, this.configuration);
            }
            catch (Exception e) {
                logger.debug("Caught error while restoring connection state to policy manager: ", (Throwable)e);
                throw e;
            }
        }
    }

    void signalResourceCreateError(Exception cause) {
        this.brokerConnection.connectError(cause);
    }

    void signalError(Exception cause) {
        this.brokerConnection.runtimeError(cause);
    }

    AMQPBridgeManager addLinkClosedInterceptor(String id, Predicate<Link> interceptor) {
        this.linkClosedinterceptors.put(id, interceptor);
        return this;
    }

    AMQPBridgeManager removeLinkClosedInterceptor(String id) {
        this.linkClosedinterceptors.remove(id);
        return this;
    }

    protected boolean invokeLinkClosedInterceptors(Link link) {
        for (Map.Entry<String, Predicate<Link>> interceptor : this.linkClosedinterceptors.entrySet()) {
            if (!interceptor.getValue().test(link)) continue;
            logger.trace("Remote link[{}] close intercepted and handled by interceptor: {}", (Object)link.getName(), (Object)interceptor.getKey());
            return true;
        }
        return false;
    }

    private void failIfShutdown() throws ActiveMQIllegalStateException {
        if (this.state == State.SHUTDOWN) {
            throw new ActiveMQIllegalStateException("The bridge manager instance has been shutdown");
        }
    }

    private static enum State {
        UNINITIALIZED,
        STOPPED,
        STARTED,
        SHUTDOWN;

    }
}

