/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.RestManagementConstants;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleExceptionSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleStateSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.FrameworkWiring;

public class FrameworkBundleStateResource
extends BaseResource {
    public FrameworkBundleStateResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundlestate+json", "application/org.osgi.bundlestate+xml"})
    @Path(value="framework/bundle/{bundleid}/state{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundle/state", summary="Retrieves a Bundle State Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleStateSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response bundleState(@PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Bundle bundle = this.bundleContext.getBundle(bundleid);
        if (bundle == null) {
            throw new WebApplicationException(404);
        }
        Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleStateSchema(bundle)));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundlestate+json" : "application/org.osgi.bundlestate+xml").map(type -> builder.type(type)).orElse(builder).build();
    }

    @PUT
    @Consumes(value={"application/org.osgi.bundlestate+json", "application/org.osgi.bundlestate+xml"})
    @Produces(value={"application/org.osgi.bundlestate+json", "application/org.osgi.bundlestate+xml"})
    @Path(value="framework/bundle/{bundleid}/state{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="PUT/bundle/state", summary="Sets the target state for the given bundle. This can, e.g., be state=32 for transitioning the bundle to started, or state=4 for stopping the bundle and transitioning it to resolved", responses={@ApiResponse(responseCode="200", description="The request was received and valid and the framework has performed a state change", content={@Content(schema=@Schema(implementation=BundleStateSchema.class))}), @ApiResponse(responseCode="400", description="The REST management service received a BundleException when trying to perform the state transition", content={@Content(mediaType="application/org.osgi.bundleexception+json", schema=@Schema(implementation=BundleExceptionSchema.class)), @Content(mediaType="application/org.osgi.bundleexception+xml", schema=@Schema(implementation=BundleExceptionSchema.class))}), @ApiResponse(responseCode="402", description="The requested target state is not reachable from the current bundle state or is not a target state"), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="415", description="The request had a media type that is not supported by the REST management service")})
    public Response bundleState(BundleStateSchema bundleStateDTO, @PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            Bundle bundle = this.bundleContext.getBundle(bundleid);
            if (bundle == null) {
                throw new WebApplicationException("there is no bundle with the given bundle id", 404);
            }
            int currentState = bundle.getState();
            if ((currentState & 2) == 2 || (currentState & 4) == 4) {
                if ((bundleStateDTO.state & 0x20) == 32) {
                    bundle.start(bundleStateDTO.options);
                } else if ((bundleStateDTO.state & 4) == 4) {
                    ((FrameworkWiring)this.framework.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(bundle));
                }
            } else if ((currentState & 0x20) == 32) {
                if ((bundleStateDTO.state & 4) == 4) {
                    bundle.stop(bundleStateDTO.options);
                }
            } else {
                throw new WebApplicationException(String.format("the requested target state [%s] is not reachable from the current bundle state [%s] or is not a target state", bundleStateDTO.state, currentState), 402);
            }
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleStateSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundlestate+json" : "application/org.osgi.bundlestate+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception, 400);
        }
    }
}

