/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.trevni.Codec;

public class BZip2Codec
extends Codec {
    private ByteArrayOutputStream outputBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 65536;

    @Override
    ByteBuffer compress(ByteBuffer uncompressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(uncompressedData.remaining());
        try (BZip2CompressorOutputStream outputStream = new BZip2CompressorOutputStream((OutputStream)baos);){
            outputStream.write(uncompressedData.array(), BZip2Codec.computeOffset(uncompressedData), uncompressedData.remaining());
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Override
    ByteBuffer decompress(ByteBuffer compressedData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressedData.array(), BZip2Codec.computeOffset(compressedData), compressedData.remaining());
        try (BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)bais);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            int readCount = -1;
            while ((readCount = inputStream.read(buffer, compressedData.position(), buffer.length)) > 0) {
                baos.write(buffer, 0, readCount);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (null == this.outputBuffer) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }
}

