<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

### Renaming schema fields

```RenameFields``` allows specific fields in a schema to be renamed. The field values in input rows are left unchanged, only the schema is modified. This transform is often used to prepare records for output to a schema-aware sink, such as an RDBMS, to make sure that the ```PCollection``` schema field names match that of the output. It can also be used to rename fields generated by other transforms to make them more usable (similar to SELECT AS in SQL). Nested fields can also be renamed using the field-selection syntax.

```
input.apply(RenameFields.<PurchasePojo>create()
  .rename("userId", "userIdentifier")
  .rename("shippingAddress.streetAddress", "shippingAddress.street"));
```

Results in the same set of unmodified input elements, however the schema on the ```PCollection``` has been changed to rename **userId** to **userIdentifier** and **shippingAddress.streetAddress** to **shippingAddress.street**.

### Playground exercise

In the playground window you can find examples of using the `Rename`. By running this example, you will see user statistics in certain games.
Since you specified in the `score` `scheme` as equal to the field with `userId`, it can be changed directly:
```
.apply(RenameFields.create()
                        .rename("userId", "id")
                        .rename("userName", "name")
                        .rename("score","point"));
```